/*
 * Decompiled with CFR 0.152.
 */
package com.walker.db.page;

import com.walker.db.page.Pager;
import java.util.List;

public abstract class AbstractPager
implements Pager {
    private int pageIndex = 1;
    private int pageSize = 1;
    private int pageCount = 1;
    private long totalRows = 0L;

    public AbstractPager(int pageIndex, int pageSize, long totalRows) {
        this.setPageIndex(pageIndex);
        this.setPageSize(pageSize);
        if (totalRows > 0L) {
            this.setTotalRows(totalRows);
        }
    }

    protected abstract Class<?> buildData();

    @Override
    public boolean isEmpty() {
        return this.totalRows == 0L;
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    public long getTotalRows() {
        return this.totalRows;
    }

    @Override
    public void setTotalRows(long totalRows) {
        if (totalRows < 0L) {
            throw new IllegalArgumentException("totalRows must more than 0.");
        }
        if (totalRows == 0L) {
            return;
        }
        this.totalRows = totalRows;
        this.pageCount = (int)(totalRows / (long)this.pageSize + (long)(totalRows % (long)this.pageSize == 0L ? 0 : 1));
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        if (this.pageIndex > 1 && pageIndex >= 1) {
            throw new IllegalStateException("can't invoke method of setPageIndex() repeatedly.");
        }
        if (pageIndex < 1) {
            pageIndex = 1;
        }
        this.pageIndex = pageIndex;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (this.pageSize > 1 && pageSize >= 0) {
            throw new IllegalStateException("can't invoke method of setPageSize() repeatedly., this.pageSize = " + this.pageSize + ", pageSize = " + pageSize);
        }
        if (pageSize < 1) {
            pageSize = 1;
        }
        this.pageSize = pageSize;
    }

    @Override
    public long getFirstRowIndexInPage() {
        return (this.pageIndex - 1) * this.pageSize;
    }

    @Override
    public long getEndRowIndexPage() {
        long endDataIndex = 0L;
        if (this.totalRows <= 1L) {
            return endDataIndex;
        }
        long firstDataIndex = this.getFirstRowIndexInPage();
        endDataIndex = this.totalRows >= (long)this.pageSize ? (this.hasNextPage() ? firstDataIndex + (long)this.pageSize - 1L : firstDataIndex + (this.totalRows - (long)((this.pageCount - 1) * this.pageSize)) - 1L) : this.totalRows - 1L;
        return endDataIndex;
    }

    @Override
    public boolean hasNextPage() {
        return this.pageIndex < this.pageCount;
    }

    @Override
    public boolean hasPreviousPage() {
        return this.pageIndex > 1;
    }

    @Override
    public List<Object> getDatasObject() {
        throw new UnsupportedOperationException("error: no implements.");
    }

    public String toString() {
        return "pager: {pageIndex=" + this.pageIndex + ", pageSize=" + this.pageSize + ", pageCount=" + this.pageCount + ", totalRows=" + this.totalRows + "}";
    }
}

