/*
 * Decompiled with CFR 0.152.
 */
package com.walker.di;

import com.walker.di.BatchLoadListener;
import com.walker.di.BusinessImportException;
import com.walker.di.DataImportException;
import com.walker.di.DataImportor;
import com.walker.di.ErrorWriter;
import com.walker.di.UpdateType;
import com.walker.infrastructure.utils.KeyValue;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataImportor
implements DataImportor {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final long MAX_BATCH_SIZE = 1024L;
    private boolean brokenContinue = false;
    private String brokenId = null;
    private boolean batchSupport = false;
    private long batchSize = 1024L;
    private Object source = null;
    private List<String> fieldNames = null;
    private long saveSizeOnce = 200L;
    private int ignoreRows = 0;
    private long sleepMillSeconds = 0L;
    private BatchLoadListener batchLoadListener = null;
    private long importSize = 0L;
    private String id;
    private boolean showError = true;
    private String errorFile = null;
    private String saveFileFolder = null;
    private ErrorWriter errorWriter = null;
    private int headRowNumber = 2;
    private UpdateType updateType = UpdateType.Ignore;

    public void setBatchLoadListener(BatchLoadListener batchLoadListener) {
        this.batchLoadListener = batchLoadListener;
    }

    @Override
    public void load() throws DataImportException {
        if (this.source == null) {
            throw new IllegalArgumentException("\u52a0\u8f7d\u6e90\u4e0d\u5b58\u5728:source == null", null);
        }
        if (this.brokenContinue && StringUtils.isEmpty(this.brokenId)) {
            throw new IllegalArgumentException("\u5728\u65ad\u70b9\u7eed\u4f20(\u5bfc)\u6a21\u5f0f\u4e0b\uff0cbrokenId\u5fc5\u987b\u8bbe\u7f6e");
        }
        if (StringUtils.isEmpty(this.id)) {
            throw new IllegalArgumentException("id\u5fc5\u987b\u8bbe\u7f6e:\u7528\u4e8e\u533a\u5206\u4e1a\u52a1\u591a\u6b21\u5bfc\u5165");
        }
        if (this.batchSupport) {
            if (this.batchLoadListener == null) {
                throw new IllegalArgumentException("batchLoadListener\u672a\u8bbe\u7f6e");
            }
            this.acquireImportBatch(this.batchLoadListener, this.source);
            this.closeErrorWriter();
            return;
        }
        List<Object[]> rows = this.acquireImportDataList(this.source);
        if (StringUtils.isEmptyList(rows)) {
            this.logger.warn("\u672a\u52a0\u8f7d\u5230\u4efb\u4f55\u5bfc\u5165\u6570\u636e");
            return;
        }
        this.doExecuteImport(rows, this.getFieldNames());
        this.closeErrorWriter();
    }

    protected void doExecuteImport(List<Object[]> rows, List<String> fieldNames) throws DataImportException {
        if (StringUtils.isEmptyList(fieldNames)) {
            throw new DataImportException("\u5bfc\u5165\u6570\u636e\u4e2d\u672a\u627e\u5230\u6807\u9898\u5217\u4fe1\u606f", null);
        }
        if (this.showError && this.errorWriter == null) {
            this.logger.debug("\u521d\u59cb\u5316: ErrorWriter...");
            this.errorWriter = this.acquireErrorWriter(this.id, fieldNames);
            if (this.errorWriter == null) {
                throw new UnsupportedOperationException("ErrorWriter\u672a\u5b9e\u73b0\u4ee3\u7801\uff0c\u8bf7\u4fee\u6539");
            }
        }
        this.doValidate(rows);
        ArrayList<Object> savedList = null;
        long brokenIndex = 0L;
        for (Object[] row : rows) {
            if (savedList == null) {
                savedList = new ArrayList<Object[]>(256);
            }
            if (savedList.size() == rows.size() - 1) {
                savedList.add(row);
                ++brokenIndex;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u6700\u540e\u4e00\u6279\u4e0d\u8d85\u8fc7'" + this.saveSizeOnce + "',\u6700\u540e\u4e00\u4e2a\u5143\u7d20\u52a0\u5165\u4fdd\u5b58\u961f\u5217");
                }
            }
            if ((long)savedList.size() >= this.saveSizeOnce || savedList.size() == rows.size()) {
                this.logger.debug("\u5f00\u59cb\u4fdd\u5b58\u4e00\u6b21:" + savedList.size());
                try {
                    this.saveImportData(savedList, fieldNames);
                    this.increaseImportSize(savedList.size());
                    savedList.clear();
                    savedList = new ArrayList(256);
                }
                catch (Exception ex) {
                    if (this.brokenContinue) {
                        this.logger.error("\u5bfc\u5165\u51fa\u73b0\u9519\u8bef\uff0c\u542f\u7528\u65ad\u70b9\u7eed\u4f20(\u5bfc)\uff0c\u8bb0\u5f55\u5f53\u524d\u8bb0\u5f55\u4f4d\u7f6e:" + brokenIndex);
                        this.saveBrokenInfo(brokenIndex);
                    }
                    if (ex instanceof BusinessImportException) {
                        throw ex;
                    }
                    throw new DataImportException("\u5bfc\u5165\u6570\u636e\u51fa\u73b0\u5f02\u5e38:" + ex.getMessage(), ex);
                }
            }
            savedList.add(row);
            ++brokenIndex;
        }
    }

    protected boolean doValidate(List<Object[]> rows) {
        boolean success = true;
        TreeMap<String, String> map = null;
        List<KeyValue<String, String>> kv = null;
        Object[] srcObject = null;
        String error = null;
        Iterator<Object[]> it = rows.iterator();
        while (it.hasNext()) {
            srcObject = it.next();
            map = this.getDataMap(srcObject);
            kv = this.getKeyValueList(srcObject, this.fieldNames);
            error = this.validateData(map);
            if (error == null) continue;
            if (success) {
                success = false;
            }
            if (this.showError) {
                this.errorWriter.write(kv, error);
            }
            it.remove();
        }
        return success;
    }

    protected TreeMap<String, String> getDataMap(Object[] data) {
        if (this.fieldNames == null) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u5217\u4fe1\u606f\uff0c\u65e0\u6cd5\u83b7\u53d6\u6570\u636eMap");
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            map.put(this.fieldNames.get(i), data[i] == null ? null : data[i].toString());
        }
        return map;
    }

    protected List<KeyValue<String, String>> getKeyValueList(Object[] data, List<String> fieldNames) {
        ArrayList<KeyValue<String, String>> list = new ArrayList<KeyValue<String, String>>();
        KeyValue<String, Object> kv = null;
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            kv = new KeyValue<String, Object>(fieldNames.get(i), (data[i] == null ? null : data[i].toString()));
            list.add(kv);
        }
        return list;
    }

    @Override
    public boolean isBatchSupport() {
        return this.batchSupport;
    }

    @Override
    public boolean isBrokenContinue() {
        return this.brokenContinue;
    }

    @Override
    public void setBatchEnabled() {
        this.setBatchSize(1024L);
    }

    @Override
    public void setBatchSize(long batchSize) {
        if (batchSize < 0L) {
            throw new IllegalArgumentException("batchSize\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (batchSize > 1024L) {
            throw new IllegalArgumentException("batchSize\u5efa\u8bae\u4e0d\u8981\u5927\u4e8e:1024");
        }
        if (batchSize <= this.saveSizeOnce) {
            throw new IllegalArgumentException("\u6279\u91cf\u5927\u5c0f\u5fc5\u987b\u5927\u4e8e'\u6bcf\u4e2a\u4fdd\u5b58\u6570\u91cf':" + this.saveSizeOnce);
        }
        this.batchSize = batchSize;
        this.batchSupport = true;
    }

    @Override
    public void setBrokenContinue(boolean allow) {
        this.brokenContinue = allow;
    }

    @Override
    public void setBrokenId(String brokenId) {
        this.brokenId = brokenId;
    }

    @Override
    public void setFieldNames(List<String> fieldNames) {
        if (this.fieldNames != null) {
            return;
        }
        if (StringUtils.isEmptyList(fieldNames)) {
            throw new IllegalArgumentException("fieldNames \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.fieldNames = fieldNames;
    }

    @Override
    public void setIgnoreRows(int number) {
        if (number <= 0) {
            throw new IllegalArgumentException("\u5ffd\u7565\u884c\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        this.ignoreRows = number;
    }

    @Override
    public void setBatchSleepMills(long millSeconds) {
        if (millSeconds <= 0L || millSeconds >= 10000L) {
            throw new IllegalArgumentException("\u8bf7\u8bbe\u7f6e\u5408\u7406\u6279\u91cf\u5bfc\u5165\u95f4\u9694\u65f6\u95f4\uff0c\u4e00\u822c\u5728: 100 - 5000 \u4e4b\u95f4");
        }
        this.sleepMillSeconds = millSeconds;
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public long getBatchSize() {
        return this.batchSize;
    }

    @Override
    public long getSuccessSize() {
        return this.importSize;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setShowError(boolean showError) {
        this.showError = showError;
    }

    @Override
    public void setSaveFileFolder(String saveFileFolder) {
        this.saveFileFolder = saveFileFolder;
    }

    @Override
    public String getErrorFile() {
        if (StringUtils.isEmpty(this.saveFileFolder)) {
            throw new IllegalStateException("saveFileFolder\u672a\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u4fdd\u5b58\u9519\u8bef\u6587\u4ef6");
        }
        if (this.errorFile == null) {
            this.errorFile = this.saveFileFolder + this.getId() + '_' + this.getImportFileSuffix();
        }
        return this.errorFile;
    }

    protected String getSaveFileFolder() {
        return this.saveFileFolder;
    }

    public int getIgnoreRows() {
        return this.ignoreRows;
    }

    public long getSleepMillSeconds() {
        return this.sleepMillSeconds;
    }

    protected void setSource(Object source) {
        if (source == null) {
            throw new IllegalArgumentException("source is not null!");
        }
        this.source = source;
    }

    public void setSaveSizeOnce(long saveSizeOnce) {
        if (saveSizeOnce < 0L || saveSizeOnce > this.batchSize) {
            throw new IllegalArgumentException("\u6bcf\u6b21\u4fdd\u5b58\u6570\u636e\u91cf\u53ea\u80fd\u5728:0-" + this.batchSize + "\u4e4b\u95f4");
        }
        this.saveSizeOnce = saveSizeOnce;
    }

    @Override
    public void setHeadRowNumber(int headRowNumber) {
        this.headRowNumber = headRowNumber;
    }

    @Override
    public void setUpdateType(UpdateType updateType) {
        this.updateType = updateType;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public int getHeadRowNumber() {
        return this.headRowNumber;
    }

    public long getSaveSizeOnce() {
        return this.saveSizeOnce;
    }

    protected void increaseImportSize(long addSize) {
        this.importSize += addSize;
    }

    protected boolean isShowError() {
        return this.showError;
    }

    protected abstract List<Object[]> acquireImportDataList(Object var1) throws DataImportException;

    protected abstract void acquireImportBatch(BatchLoadListener var1, Object var2) throws DataImportException;

    protected abstract String validateData(Map<String, String> var1);

    protected abstract void saveImportData(List<Object[]> var1, List<String> var2) throws BusinessImportException;

    protected abstract void saveBrokenInfo(long var1);

    protected abstract ErrorWriter acquireErrorWriter(String var1, List<String> var2);

    protected abstract String getImportFileSuffix();

    private void closeErrorWriter() {
        if (this.errorWriter != null) {
            this.errorWriter.close();
            this.logger.debug("\u5173\u95ed:errorWriter");
        }
    }
}

