/*
 * Decompiled with CFR 0.152.
 */
package com.walker.di;

import com.walker.di.TemplateException;
import com.walker.di.TemplateGenerator;
import com.walker.infrastructure.utils.StringUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTemplateGenerator<T>
implements TemplateGenerator<T> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public T generate(Object option) throws TemplateException {
        if (!this.checkOption(option)) {
            throw new TemplateException("option\u53c2\u6570\u6821\u9a8c\u672a\u901a\u8fc7", null);
        }
        List<Map<String, String>> content = this.acquireWriteContent(option);
        if (StringUtils.isEmptyList(content)) {
            throw new TemplateException("\u672a\u83b7\u53d6\u5230\u5199\u5165\u6a21\u677f\u5185\u5bb9", null);
        }
        return this.writeContent(content, option);
    }

    protected boolean checkOption(Object option) {
        return true;
    }

    protected abstract List<Map<String, String>> acquireWriteContent(Object var1);

    protected abstract T writeContent(List<Map<String, String>> var1, Object var2) throws TemplateException;
}

