/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.arguments;

import com.walker.infrastructure.arguments.ArgumentsException;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.ElementNotFoundException;
import com.walker.infrastructure.arguments.Group;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.arguments.support.DefaultVariable;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.security.SystemLogMan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArgumentsManager
implements ArgumentsManager {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Object source;
    private Map<String, Group> groupMap = new TreeMap<String, Group>();
    private ConcurrentHashMap<String, List<String>> variableMap = new ConcurrentHashMap(8);
    private ConcurrentHashMap<String, Variable> allVars = new ConcurrentHashMap(32);
    private Object lock = new Object();

    @Override
    public void setSource(Object source) {
        assert (source != null);
        this.source = source;
    }

    public void afterPropertiesSet() throws Exception {
        SystemLogMan.getInstance().checkMan();
        List<Group> groupList = null;
        try {
            groupList = this.load(this.source);
        }
        catch (Exception ex) {
            throw new ArgumentsException("\u4e1a\u52a1\u52a0\u8f7d\u914d\u7f6e\u53c2\u6570\u5931\u8d25:" + ex.getMessage(), ex);
        }
        this.initGroup(groupList);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("~~~~~~~~~~~~~~~~~ \u7cfb\u7edf\u52a0\u8f7d\u6240\u6709\u914d\u7f6e\u53c2\u6570-start ~~~~~~~~~~~~~~~~~");
            for (Variable v : this.allVars.values()) {
                this.logger.debug(v.toString());
            }
            this.logger.debug("~~~~~~~~~~~~~~~~~ \u7cfb\u7edf\u52a0\u8f7d\u6240\u6709\u914d\u7f6e\u53c2\u6570-end ~~~~~~~~~~~~~~~~~");
        }
    }

    private void initGroup(List<Group> groupList) {
        if (groupList != null) {
            Collections.sort(groupList);
            for (Group g : groupList) {
                this.groupMap.put(g.getId(), g);
                this.initVariableInGroup(g);
            }
        }
    }

    private void initVariableInGroup(Group group) {
        List<Variable> varList = group.getChildren();
        if (varList != null && varList.size() > 0) {
            ArrayList<String> varIds = new ArrayList<String>(8);
            for (Variable v : varList) {
                this.allVars.put(v.getId(), v);
                varIds.add(v.getId());
            }
            this.variableMap.put(group.getId(), varIds);
        } else {
            this.variableMap.put(group.getId(), null);
        }
    }

    protected abstract List<Group> load(Object var1) throws Exception;

    @Override
    public Variable getVariable(String id) {
        assert (StringUtils.isNotEmpty(id));
        Variable var = this.allVars.get(id);
        if (var == null) {
            throw new ElementNotFoundException("variable not found: " + id);
        }
        return var;
    }

    @Override
    public void persist(String variableId, Object value) {
        if (this.groupMap.size() > 1) {
            throw new ArgumentsException("\u5b58\u5728\u591a\u4e2a\u5206\u7ec4\uff0c\u8bf7\u8c03\u7528\u65b9\u6cd5: persist(String groupId, String variableId, Object value)");
        }
        String groupId = this.groupMap.keySet().iterator().next();
        this.persist(groupId, variableId, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist(String groupId, String variableId, Object value) {
        assert (StringUtils.isNotEmpty(groupId));
        assert (value != null);
        try {
            this.saveVariable(groupId, variableId, value);
        }
        catch (Exception e) {
            throw new ArgumentsException("\u66f4\u65b0\u53ef\u53d8\u53c2\u6570\u5230\u4e1a\u52a1\u4e2d\u51fa\u73b0\u9519\u8bef: " + e.getMessage(), e);
        }
        Object object = this.lock;
        synchronized (object) {
            this.updateCache(groupId, variableId, value);
        }
    }

    private void updateCache(String groupId, String variableId, Object value) {
        if (this.groupMap.get(groupId) == null) {
            throw new IllegalArgumentException("not found group id: " + groupId);
        }
        List<String> existVarSet = this.variableMap.get(groupId);
        if (existVarSet == null) {
            throw new ArgumentsException("not found variable in cache: " + variableId);
        }
        if (!existVarSet.contains(variableId)) {
            throw new ElementNotFoundException("var id: " + variableId);
        }
        DefaultVariable current = (DefaultVariable)this.allVars.get(variableId);
        current.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist(List<Object[]> changedList) {
        if (changedList == null) {
            return;
        }
        for (Object[] arr : changedList) {
            if (arr.length != 3) {
                throw new IllegalArgumentException("\u8f93\u5165\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u96c6\u5408\u4e2d\u4e3a\u6570\u7ec4\uff0c\u6bcf\u4e2a\u6570\u7ec4\u9700\u8981\u4e09\u4e2a\u5143\u7d20: groupId, variableId, value.");
            }
            if (StringUtils.isEmpty(arr[0].toString())) {
                throw new IllegalArgumentException("\u7b2c\u4e00\u4e2a\u53c2\u6570:groupId\u4e0d\u5b58\u5728\u6216\u8005\u662f\u7a7a\u503c");
            }
            if (StringUtils.isEmpty(arr[1].toString())) {
                throw new IllegalArgumentException("\u7b2c\u4e8c\u4e2a\u53c2\u6570:variableId\u4e0d\u5b58\u5728\u6216\u8005\u662f\u7a7a\u503c");
            }
            if (arr[2] != null) continue;
            throw new IllegalArgumentException("\u7b2c\u4e09\u4e2a\u53c2\u6570:value\u4e0d\u5b58\u5728\u6216\u8005\u662f\u7a7a\u503c");
        }
        try {
            this.saveVariables(changedList);
        }
        catch (Exception e) {
            throw new ArgumentsException("\u66f4\u65b0\u53ef\u53d8\u53c2\u6570\u5230\u4e1a\u52a1\u4e2d\u51fa\u73b0\u9519\u8bef: " + e.getMessage(), e);
        }
        Object object = this.lock;
        synchronized (object) {
            for (Object[] args : changedList) {
                this.updateCache(args[0].toString(), args[1].toString(), args[2]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(List<Object[]> insertList) {
        if (insertList == null) {
            return;
        }
        for (Object[] arr : insertList) {
            if (arr.length != 2) {
                throw new IllegalArgumentException("\u8f93\u5165\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u96c6\u5408\u4e2d\u4e3a\u6570\u7ec4\uff0c\u6bcf\u4e2a\u6570\u7ec4\u9700\u8981\u4e24\u4e2a\u5143\u7d20: group, variable.");
            }
            if (StringUtils.isEmpty(arr[0].toString())) {
                throw new IllegalArgumentException("\u7b2c\u4e00\u4e2a\u53c2\u6570:group\u4e0d\u5b58\u5728\u6216\u8005\u662f\u7a7a\u503c");
            }
            if (!StringUtils.isEmpty(arr[1].toString())) continue;
            throw new IllegalArgumentException("\u7b2c\u4e8c\u4e2a\u53c2\u6570:variable\u4e0d\u5b58\u5728\u6216\u8005\u662f\u7a7a\u503c");
        }
        try {
            this.insertVariables(insertList);
        }
        catch (Exception e) {
            throw new ArgumentsException("\u65b0\u5efa\u53ef\u53d8\u53c2\u6570\u51fa\u73b0\u9519\u8bef: " + e.getMessage(), e);
        }
        Object object = this.lock;
        synchronized (object) {
            for (Object[] args : insertList) {
                this.insertCache((Group)args[0], (Variable)args[1]);
            }
        }
    }

    protected abstract void saveVariable(String var1, String var2, Object var3) throws Exception;

    protected abstract void saveVariables(List<Object[]> var1) throws Exception;

    protected abstract void insertVariables(List<Object[]> var1) throws Exception;

    private void insertCache(Group group, Variable variable) {
        assert (group != null);
        assert (variable != null);
        if (!this.groupMap.containsKey(group.getId())) {
            this.groupMap.put(group.getId(), group);
        }
        if (!this.allVars.containsKey(variable.getId())) {
            this.allVars.put(variable.getId(), variable);
            List<String> varList = this.variableMap.get(group.getId());
            if (varList == null) {
                varList = new ArrayList<String>(2);
                this.variableMap.put(group.getId(), varList);
            }
            varList.add(variable.getId());
        }
    }

    @Override
    public List<Group> getGroupList() {
        if (this.groupMap.size() == 0) {
            return null;
        }
        ArrayList<Group> list = new ArrayList<Group>(8);
        Iterator<Group> it = this.groupMap.values().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public List<Variable> getVariableList(String groupId) {
        assert (StringUtils.isNotEmpty(groupId));
        if (this.groupMap.size() == 0) {
            return null;
        }
        List<String> varIds = this.variableMap.get(groupId);
        if (varIds == null) {
            return null;
        }
        ArrayList<Variable> result = new ArrayList<Variable>(8);
        Variable var = null;
        for (String vid : varIds) {
            var = this.allVars.get(vid);
            if (var == null) {
                throw new ElementNotFoundException("var id: " + vid);
            }
            result.add(var);
        }
        return result;
    }

    public void destroy() throws Exception {
        this.source = null;
        this.groupMap.clear();
        this.variableMap.clear();
        this.allVars.clear();
    }
}

