/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.arguments;

import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.ArgumentsManagerFactory;
import com.walker.infrastructure.core.NestedRuntimeException;
import com.walker.infrastructure.utils.FileCopyUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.ClassPathResource;

public class ArgumentsManagerFactoryBean
implements FactoryBean<ArgumentsManager> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_CONFIG_FILENAME = "app_variables";
    private ArgumentsManager defaultArgumentManager;
    private String filename;
    private String suffix = "";
    private boolean openClasspath = true;

    public void setOpenClasspath(boolean openClasspath) {
        this.openClasspath = openClasspath;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public ArgumentsManager getObject() throws Exception {
        if (this.defaultArgumentManager != null) {
            return this.defaultArgumentManager;
        }
        if (StringUtils.isNotEmpty(this.filename)) {
            this.defaultArgumentManager = ArgumentsManagerFactory.createXmlArgumentsManager(this.filename, false);
        } else if (!this.openClasspath) {
            String absoluteFilename = System.getProperty("java.io.tmpdir") + DEFAULT_CONFIG_FILENAME + this.suffix + ".xml";
            this.logger.info("------------- ArgumentsManager\u914d\u7f6e\u6587\u4ef6: " + absoluteFilename);
            this.doCheckExist(absoluteFilename);
            this.defaultArgumentManager = ArgumentsManagerFactory.createXmlArgumentsManager(absoluteFilename, false);
        } else {
            String classpathFile = "app_variables.xml";
            this.logger.info("------------- ArgumentsManager\u914d\u7f6e\u6587\u4ef6\u5728classpath\u4e2d: " + classpathFile);
            this.defaultArgumentManager = ArgumentsManagerFactory.createXmlArgumentsManager(classpathFile, true);
        }
        return this.defaultArgumentManager;
    }

    private void doCheckExist(String filepath) {
        File file = new File(filepath);
        ClassPathResource defaultVariableSource = new ClassPathResource("app_variables.xml");
        if (!file.exists()) {
            try {
                file.createNewFile();
                FileCopyUtils.copy(defaultVariableSource.getFile(), file);
                this.logger.debug("\u521b\u5efavariable\u914d\u7f6e\u6587\u4ef6\u6210\u529f: " + filepath);
            }
            catch (IOException e) {
                this.logger.error("\u521b\u5efa\u53ef\u53d8\u53c2\u6570\u914d\u7f6e\u6587\u4ef6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                throw new NestedRuntimeException(filepath);
            }
        }
        long destFileModified = file.lastModified();
        long srcFileModified = 0L;
        try {
            srcFileModified = defaultVariableSource.getFile().lastModified();
            this.logger.debug("variable\u6587\u4ef6\u539f\u59cb\u65f6\u95f4: " + srcFileModified + ", \u76ee\u7684\u6587\u4ef6\u4fee\u6539\u65f6\u95f4: " + destFileModified);
            if (srcFileModified > destFileModified) {
                this.logger.debug("\u539f\u59cb\u914d\u7f6e\u6587\u4ef6\u53d8\u5316\uff0c\u91cd\u65b0\u8986\u76d6\u76ee\u7684\u6587\u4ef6");
                FileCopyUtils.copy(defaultVariableSource.getFile(), file);
            }
        }
        catch (IOException e) {
            throw new NestedRuntimeException(e.getMessage());
        }
    }

    public Class<?> getObjectType() {
        return ArgumentsManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

