/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.scheduler;

import com.walker.infrastructure.core.NestedRuntimeException;
import com.walker.infrastructure.scheduler.TimedTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTimedTask
implements TimedTask {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long TIMED_MIN_PERIOD = 5000L;
    private static final long TIMED_MIN_DELAY = 30000L;
    private static final int MAX_ERROR_COUNT = 10;
    private int errorCount = 0;
    private long delay = 5000L;
    private long period = 0L;

    @Override
    public long getDelay() {
        if (this.delay == 0L) {
            this.delay = 30000L;
        }
        return this.delay;
    }

    @Override
    public long getPeriod() {
        if (this.period < 0L) {
            throw new NullPointerException("period must be set in TimedTask! It is more than 0.");
        }
        if (this.period > 0L && this.period < 5000L) {
            throw new NestedRuntimeException("period must more than5 seconds in TimedTask!");
        }
        return this.period;
    }

    @Override
    public void setDelay(long delays) {
        this.delay = delays < 30000L ? 30000L : delays;
    }

    @Override
    public void setPeriod(long periods) {
        this.period = periods > 0L && periods < 5000L ? 5000L : periods;
    }

    @Override
    public void run() {
        if (this.period == 0L) {
            this.logger.debug("\u4efb\u52a1\u6267\u884c\u5ffd\u7565\uff0c\u8bbe\u7f6e\u95f4\u9694\u4e3a0");
            return;
        }
        if (this.errorCount > 10) {
            this.logger.debug("//*************\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u9519\u8bef\uff0c\u5df2\u8d85\u51fa\u9519\u8bef\u6700\u5927\u503c!");
        }
        try {
            this.execute();
        }
        catch (Exception e) {
            this.logger.warn("execute error in TimedTask: " + this.getClass().getName());
            this.logger.error(e.getMessage());
            ++this.errorCount;
        }
    }

    public abstract void execute() throws Exception;
}

