/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.time;

import com.walker.infrastructure.time.TimeRange;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;

public class TimeRangeUtils {
    public static final TimeRange getDateLimit(String data) {
        if (StringUtils.isEmpty(data)) {
            return null;
        }
        Long startTime = null;
        Long endTime = null;
        if (data.equals("today")) {
            startTime = TimeRangeUtils.getCurrentDateTimeStart();
            endTime = startTime + 235959L;
        } else if (data.equals("yesterday")) {
            startTime = DateUtils.getAfterLongTime(TimeRangeUtils.getCurrentDateTimeStart(), -1);
            endTime = startTime + 235959L;
        } else if (data.equals("lately7")) {
            startTime = DateUtils.getAfterLongTime(TimeRangeUtils.getCurrentDateTimeStart(), -6);
        } else if (data.equals("lately30")) {
            startTime = DateUtils.getAfterLongTime(TimeRangeUtils.getCurrentDateTimeStart(), -30);
        } else if (data.equals("week")) {
            startTime = DateUtils.getCurrentWeekStartDay();
            endTime = DateUtils.getAfterLongTime(startTime, 6) + 235959L;
        } else if (data.equals("preWeek")) {
            startTime = DateUtils.getAfterLongTime(DateUtils.getCurrentWeekStartDay(), -7);
            endTime = DateUtils.getAfterLongTime(startTime, 6) + 235959L;
        } else if (data.equals("month")) {
            startTime = DateUtils.getCurrentMonthStartDay();
            endTime = DateUtils.getCurrentMonthEndDay();
        } else if (data.equals("preMonth")) {
            startTime = DateUtils.getLastMonthStartDay();
            endTime = DateUtils.getLastMonthEndDay();
        } else if (data.equals("year")) {
            startTime = DateUtils.getCurrentYearStartDay();
            endTime = DateUtils.getCurrentYearEndDay();
        } else if (data.equals("preYear")) {
            startTime = DateUtils.getLastYearStartDay();
            endTime = DateUtils.getLastYearEndDay();
        } else {
            String[] timeArray = StringUtils.commaDelimitedListToStringArray(data);
            if (timeArray == null || timeArray.length == 0) {
                throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8bbe\u7f6e\u4e00\u4e2a\u8303\u56f4\uff0c\u5982\uff1a[ 2023-06-02,2023-06-05 ], error=" + data);
            }
            startTime = DateUtils.toLongDateTime(timeArray[0]);
            if (timeArray.length == 2) {
                endTime = DateUtils.toLongDateTime(timeArray[1]) + 235959L;
            }
        }
        return new TimeRange(startTime, endTime);
    }

    private static final long getCurrentDateTimeStart() {
        long currentDate = DateUtils.getDateNumber(System.currentTimeMillis());
        return currentDate * 1000000L;
    }
}

