/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.tree;

import com.walker.infrastructure.tree.TreeNode;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTreeGenerator<T> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean multiRoot = true;
    private TreeNode dummyRoot = null;
    private Map<Long, TreeNode> rootMap = new TreeMap<Long, TreeNode>();
    private Map<Long, TreeNode> childMap = new TreeMap<Long, TreeNode>();
    private long defaultParentId = 0L;

    public AbstractTreeGenerator(String dummyRootName) {
        if (StringUtils.isNotEmpty(dummyRootName)) {
            this.dummyRoot = new TreeNode(0L, dummyRootName, null, 0L);
        }
    }

    public void setMultiRoot(boolean multiRoot) {
        this.multiRoot = multiRoot;
    }

    public TreeNode getTreeRoot() {
        if (this.multiRoot) {
            throw new IllegalStateException("\u5b58\u5728\u591a\u4e2a\u6839\u8282\u70b9\uff0c\u8bf7\u8c03\u7528\u65b9\u6cd5:getTreeRootList().");
        }
        if (this.dummyRoot != null) {
            return this.dummyRoot;
        }
        return this.rootMap.values().iterator().next();
    }

    public List<TreeNode> getTreeRootList() {
        if (!this.multiRoot) {
            throw new IllegalStateException("\u5b58\u5728\u591a\u4e2a\u6839\u8282\u70b9\uff0c\u8bf7\u8c03\u7528\u65b9\u6cd5:getTreeRoot().");
        }
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        for (TreeNode node : this.rootMap.values()) {
            list.add(node);
        }
        return list;
    }

    public void setEntityList(List<T> datas) {
        if (StringUtils.isEmptyList(datas)) {
            return;
        }
        TreeNode node = null;
        for (T obj : datas) {
            node = this.toTreeNode(obj);
            if (node.getParentId() == this.defaultParentId) {
                this.rootMap.put(node.getId(), node);
                continue;
            }
            this.childMap.put(node.getId(), node);
        }
        if (this.rootMap.size() == 0) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u6839\u8282\u70b9\u3002");
        }
        if (this.childMap != null && this.childMap.size() > 0) {
            this.mountTree(this.childMap);
        }
        if (this.dummyRoot != null) {
            for (TreeNode n : this.rootMap.values()) {
                n.setParentId(this.defaultParentId);
                this.dummyRoot.addChild(n);
            }
        }
    }

    private void mountTree(Map<Long, TreeNode> childMap) {
        TreeNode _node2 = null;
        for (TreeNode _node2 : childMap.values()) {
            this.mountMiddleNode(_node2, childMap);
        }
    }

    private void mountMiddleNode(TreeNode currentNode, Map<Long, TreeNode> childMap) {
        TreeNode _parentNode = this.rootMap.get(currentNode.getParentId());
        if (_parentNode == null) {
            _parentNode = childMap.get(currentNode.getParentId());
            if (_parentNode == null) {
                throw new NullPointerException("parent node not found, current: " + currentNode);
            }
            _parentNode.addChild(currentNode);
            this.mountMiddleNode(_parentNode, childMap);
        } else if (_parentNode.getParentId() == this.defaultParentId) {
            _parentNode.addChild(currentNode);
        }
    }

    protected abstract TreeNode toTreeNode(T var1);

    public long getDefaultParentId() {
        return this.defaultParentId;
    }

    public void setDefaultParentId(long defaultParentId) {
        this.defaultParentId = defaultParentId;
    }
}

