/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.tree;

import java.util.ArrayList;
import java.util.List;

public class TreeNode
implements Comparable<TreeNode> {
    private long id;
    private String label;
    private long parentId = 0L;
    private List<TreeNode> children = null;
    private Object source = null;
    private String code;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public TreeNode(long id, String label, List<TreeNode> children, long parentId) {
        this.id = id;
        this.label = label;
        this.children = children;
        this.parentId = parentId;
    }

    public TreeNode(long id, String label, List<TreeNode> children, long parentId, String code) {
        this.id = id;
        this.label = label;
        this.children = children;
        this.parentId = parentId;
        this.code = code;
    }

    public void addChild(TreeNode node) {
        if (node != null) {
            if (this.children == null) {
                this.children = new ArrayList<TreeNode>(8);
            }
            if (!this.children.contains(node)) {
                this.children.add(node);
            }
        }
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode> children) {
        this.children = children;
    }

    public void cloneProperties(TreeNode node) {
        this.id = node.getId();
        this.label = node.getLabel();
        this.source = node.getSource();
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)obj;
            if (treeNode.id == this.id) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "[id=" + this.id + ", label=" + this.label + ", children=" + this.children + ", parentId=" + this.parentId + "]";
    }

    @Override
    public int compareTo(TreeNode o) {
        return 0;
    }
}

