/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import com.walker.infrastructure.utils.LongCalendar;
import com.walker.infrastructure.utils.LongDateHelper;
import com.walker.infrastructure.utils.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;

public abstract class DateUtils {
    public static final String TEXT_DATE_WITH_LINE = "yyyy-MM-dd";
    public static final String TEXT_DATE = "yyyyMMdd";
    public static final String TEXT_DATE_TIME_WITH_LINE = "yyyy-MM-dd HH:mm:ss";
    public static final String TEXT_DATE_TIME = "yyyyMMddHHmmss";
    public static final String TEXT_DATE_START = "yyyyMMdd000000";
    public static final String TEXT_MONTH_START = "yyyyMM01000000";
    public static final String TEXT_MONTH_END = "yyyyMMdd235959";
    public static final String TEXT_YEAR_START = "yyyy0101000000";
    public static final String TEXT_YEAR_END = "yyyy1231235959";
    private static final String LATE_OF_DAY = " 23:59:59";
    public static final String DATE_SEPARATOR_OLD = "/";
    public static final String DATE_SEPARATOR = "-";

    public static long getLastYearStartDay() {
        Calendar c = Calendar.getInstance();
        c.add(1, -1);
        SimpleDateFormat startSdf = new SimpleDateFormat(TEXT_YEAR_START);
        return Long.parseLong(startSdf.format(c.getTime()));
    }

    public static final long getLastYearEndDay() {
        Calendar c = Calendar.getInstance();
        c.add(1, -1);
        SimpleDateFormat endSdf = new SimpleDateFormat(TEXT_YEAR_END);
        return Long.parseLong(endSdf.format(c.getTime()));
    }

    public static final long getCurrentYearStartDay() {
        SimpleDateFormat dft = new SimpleDateFormat(TEXT_YEAR_START);
        return Long.parseLong(dft.format(new Date()));
    }

    public static final long getCurrentYearEndDay() {
        SimpleDateFormat dft = new SimpleDateFormat(TEXT_YEAR_END);
        return Long.parseLong(dft.format(new Date()));
    }

    public static final long getLastMonthStartDay() {
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        c.set(5, 1);
        SimpleDateFormat startSdf = new SimpleDateFormat(TEXT_MONTH_START);
        return Long.parseLong(startSdf.format(c.getTime()));
    }

    public static final long getLastMonthEndDay() {
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        c.set(5, c.getActualMaximum(5));
        SimpleDateFormat endSdf = new SimpleDateFormat(TEXT_MONTH_END);
        return Long.parseLong(endSdf.format(c.getTime()));
    }

    public static final long getCurrentMonthStartDay() {
        SimpleDateFormat dft = new SimpleDateFormat(TEXT_MONTH_START);
        return Long.parseLong(dft.format(new Date()));
    }

    public static final long getCurrentMonthEndDay() {
        Calendar c = Calendar.getInstance();
        c.set(5, c.getActualMaximum(5));
        SimpleDateFormat endSdf = new SimpleDateFormat(TEXT_MONTH_END);
        return Long.parseLong(endSdf.format(c.getTime()));
    }

    public static long getCurrentWeekStartDay() {
        Calendar c = Calendar.getInstance();
        c.add(4, 0);
        c.set(7, 2);
        SimpleDateFormat startSdf = new SimpleDateFormat(TEXT_DATE_START);
        return Long.parseLong(startSdf.format(c.getTime()));
    }

    public static final long toMillSeconds(long showTimeLong) {
        String showTimeStr = DateUtils.toShowDate(showTimeLong);
        return DateUtils.getDateLong(showTimeStr);
    }

    public static final String toShowDate(int date) {
        return LongCalendar.toString(date, DATE_SEPARATOR);
    }

    public static final String toShowDate(long date) {
        return LongCalendar.toString(date, DATE_SEPARATOR);
    }

    public static final int toIntegerDate(String showDate) {
        return (int)LongCalendar.longCalender(showDate, DATE_SEPARATOR);
    }

    public static final int toIntegerDateTime(String showDate) {
        return (int)LongCalendar.longCalender(showDate, DATE_SEPARATOR);
    }

    public static final long toLongDateTime(String showDate) {
        return LongCalendar.longCalender(showDate, DATE_SEPARATOR) * 1000000L;
    }

    public static final long getCurrentMonthFirstDayEarly() {
        return DateUtils.getDateLongEarly(LongDateHelper.getFirstDayOfMonth());
    }

    public static final long getTodayLongEarly() {
        return DateUtils.getDateLongEarly(DateUtils.getTodayForHuman());
    }

    public static final long getTodayLongLate() {
        return DateUtils.getDateLongLate(DateUtils.getTodayForHuman());
    }

    public static final String getTodayForHuman() {
        return LongCalendar.getCurrentDateView().replaceAll(DATE_SEPARATOR_OLD, DATE_SEPARATOR);
    }

    public static final String getDateTimeForHuman(long millis) {
        if (millis == 0L) {
            return "N/A";
        }
        SimpleDateFormat whippletreeTimeFormat = new SimpleDateFormat(TEXT_DATE_TIME_WITH_LINE);
        return whippletreeTimeFormat.format(new Date(millis));
    }

    public static final String getDateForHuman(long millis) {
        if (millis == 0L) {
            return "N/A";
        }
        SimpleDateFormat whippletreeDateFormat = new SimpleDateFormat(TEXT_DATE_WITH_LINE);
        return whippletreeDateFormat.format(new Date(millis));
    }

    public static final long getDateNumber(long millis) {
        if (millis == 0L) {
            return 0L;
        }
        SimpleDateFormat whippleDateFormat = new SimpleDateFormat(TEXT_DATE);
        return Long.parseLong(whippleDateFormat.format(new Date(millis)));
    }

    public static final long getDateTimeNumber(long millis) {
        if (millis == 0L) {
            return 0L;
        }
        SimpleDateFormat whippleTimeFormat = new SimpleDateFormat(TEXT_DATE_TIME);
        return Long.parseLong(whippleTimeFormat.format(new Date(millis)));
    }

    public static final long getDateTimeNumber() {
        return DateUtils.getDateTimeNumber(System.currentTimeMillis());
    }

    public static final long getDateTimeNumber(String showDateTime) {
        long millis = DateUtils.getDateLong(showDateTime);
        SimpleDateFormat whippleTimeFormat = new SimpleDateFormat(TEXT_DATE_TIME);
        return Long.parseLong(whippleTimeFormat.format(new Date(millis)));
    }

    public static final long getDateLongLate(String showDate) {
        Object input = DateUtils.checkDate(showDate);
        input = (String)input + LATE_OF_DAY;
        return DateUtils.getDateLong((String)input);
    }

    public static final long getDateLongEarly(String showDate) {
        return DateUtils.getDateLong(DateUtils.checkDate(showDate));
    }

    private static final String checkDate(String showDate) {
        assert (StringUtils.isNotEmpty(showDate));
        String input = showDate.trim();
        if (input.indexOf(":") >= 0) {
            throw new IllegalArgumentException("wrong input, format e.g. 2013-11-21.");
        }
        return input;
    }

    public static final long getDateLong(String showDateTime) {
        return DateUtils.getDate(showDateTime).getTime();
    }

    public static final Date getDate(String showDate) {
        String input = showDate.trim();
        if (input.indexOf(DATE_SEPARATOR) == -1) {
            throw new IllegalArgumentException("date of input must be separated width '-'");
        }
        try {
            if (input.indexOf(":") > 0) {
                SimpleDateFormat whippletreeTimeFormat = new SimpleDateFormat(TEXT_DATE_TIME_WITH_LINE);
                return whippletreeTimeFormat.parse(input);
            }
            SimpleDateFormat whippletreeDateFormat = new SimpleDateFormat(TEXT_DATE_WITH_LINE);
            return whippletreeDateFormat.parse(input);
        }
        catch (ParseException e) {
            throw new RuntimeException("translate date error: " + showDate, e);
        }
    }

    public static String getYearMonthValue(String showDateOrTime) {
        return showDateOrTime.substring(0, 7).replace(DATE_SEPARATOR, "");
    }

    public static String getYearMonthCurrentValue() {
        return DateUtils.getYearMonthValue(DateUtils.getDateForHuman(System.currentTimeMillis()));
    }

    public static String getDateTimeSecondForShow(long millis) {
        if (millis == 0L) {
            return "N/A";
        }
        SimpleDateFormat whippleTimeFormat = new SimpleDateFormat(TEXT_DATE_TIME);
        return whippleTimeFormat.format(new Date(millis));
    }

    public static String getDateTimeSecondForShow() {
        SimpleDateFormat whippleTimeFormat = new SimpleDateFormat(TEXT_DATE_TIME);
        return whippleTimeFormat.format(new Date(System.currentTimeMillis()));
    }

    public static long getAfterLongTime(long oldTime, int dayNum) {
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(oldTime);
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        int hour = Integer.parseInt(strDate.substring(8, 10));
        int minute = Integer.parseInt(strDate.substring(10, 12));
        int second = Integer.parseInt(strDate.substring(12, 14));
        calendar.set(year, month, day, hour, minute, second);
        calendar.add(5, dayNum);
        SimpleDateFormat whippleTimeFormat = new SimpleDateFormat(TEXT_DATE_TIME);
        String result = whippleTimeFormat.format(calendar.getTime());
        return Long.parseLong(result);
    }

    public static String getShowDateTimeAfterDays(int daysNumber) {
        Calendar now = Calendar.getInstance();
        now.add(5, daysNumber);
        SimpleDateFormat whippletreeTimeFormat = new SimpleDateFormat(TEXT_DATE_TIME_WITH_LINE);
        return whippletreeTimeFormat.format(now.getTime());
    }

    public static int[] getYearMonthDayArray(int afterDay) {
        Calendar now = Calendar.getInstance();
        now.add(5, afterDay);
        int[] yearMonthDay = new int[]{now.get(1), now.get(2) + 1, now.get(5)};
        return yearMonthDay;
    }

    public static String getShowDateAfterDays(int daysNumber) {
        Calendar now = Calendar.getInstance();
        now.add(5, daysNumber);
        SimpleDateFormat whippletreeDateFormat = new SimpleDateFormat(TEXT_DATE_WITH_LINE);
        return whippletreeDateFormat.format(now.getTime());
    }

    public static int[] getNextDay(int year, int month, int dayOfMonth, int afterDayNum) {
        LocalDate localDate = LocalDate.of(year, month, dayOfMonth);
        localDate = localDate.minusDays(-afterDayNum);
        return new int[]{localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth()};
    }

    public static int getCurrentWeekdayValue() {
        LocalDate currentDate = LocalDate.now();
        return currentDate.getDayOfWeek().getValue();
    }

    public static String getCurrentYear() {
        return DateUtils.getDateForHuman(System.currentTimeMillis()).substring(0, 4);
    }

    public static int getCurrentYearInteger() {
        Calendar now = Calendar.getInstance();
        return now.get(1);
    }

    public static String getCurrentYearMonthForHuman() {
        String showDateOrTime = DateUtils.getDateForHuman(System.currentTimeMillis());
        return showDateOrTime.substring(0, 7);
    }

    public static int getCurrentHour() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(11);
    }

    public static int getCurrentMinute() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(12);
    }

    public static int[] getCurrentHourMinute(int afterMinutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, afterMinutes);
        int[] hourMinute = new int[]{calendar.get(11), calendar.get(12)};
        return hourMinute;
    }

    public static int[] getCurrentYearMonthDay() {
        int[] result = new int[3];
        Calendar now = Calendar.getInstance();
        result[0] = now.get(1);
        result[1] = now.get(2) + 1;
        result[2] = now.get(5);
        return result;
    }

    public static int[] getCurrentYearMonthDayHourMinute() {
        int[] result = new int[5];
        Calendar now = Calendar.getInstance();
        result[0] = now.get(1);
        result[1] = now.get(2) + 1;
        result[2] = now.get(5);
        result[3] = now.get(11);
        result[4] = now.get(12);
        return result;
    }

    public static int[] getCurrentYearMonthDayHourMinute(int monthAdd, int dayAdd, int hourAdd, int minuteAdd) {
        int[] result = new int[5];
        Calendar now = Calendar.getInstance();
        if (monthAdd != 0) {
            now.add(2, monthAdd);
        }
        if (dayAdd != 0) {
            now.add(5, dayAdd);
        }
        if (hourAdd != 0) {
            now.add(10, hourAdd);
        }
        if (minuteAdd != 0) {
            now.add(12, minuteAdd);
        }
        result[0] = now.get(1);
        result[1] = now.get(2) + 1;
        result[2] = now.get(5);
        result[3] = now.get(11);
        result[4] = now.get(12);
        return result;
    }

    public static int[] getCurrentYearMonthDayHourMinuteSecond(int addSeconds) {
        int[] result = new int[6];
        Calendar now = Calendar.getInstance();
        now.add(13, addSeconds);
        result[0] = now.get(1);
        result[1] = now.get(2) + 1;
        result[2] = now.get(5);
        result[3] = now.get(11);
        result[4] = now.get(12);
        result[5] = now.get(13);
        return result;
    }

    public static int[] getCurrentYearMonthDay(int afterDays) {
        int[] result = new int[3];
        Calendar now = Calendar.getInstance();
        now.add(5, afterDays);
        result[0] = now.get(1);
        result[1] = now.get(2) + 1;
        result[2] = now.get(5);
        return result;
    }

    public static void main(String[] args) throws Exception {
        String showDate = "2013-11-20 11:18:21";
        System.out.println("normal:" + DateUtils.getDateLong(showDate));
        System.out.println(DateUtils.getDateForHuman(System.currentTimeMillis()));
        int[] secondDay = DateUtils.getNextDay(2023, 12, 31, 1);
        System.out.println(secondDay[0] + "," + secondDay[1] + "," + secondDay[2]);
    }
}

