/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.FileSystemUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public abstract class JarDeployer {
    private static final Logger logger = LoggerFactory.getLogger(JarDeployer.class);
    public static String DEPLOY_JAR_PREFIX = "walkersoft-resource-";
    public static final String DEPLOY_FILENAME = "walker-deploy.properties";
    public static final List<File> DEPLOY_WAIT_FILES = new ArrayList<File>();
    public static final Map<String, Long> DEPLOYED_FILES = new TreeMap<String, Long>();
    public static final String classpathAbsolute = PathSolver.classpathAbsolute;
    public static final String webappRootAbsolute = PathSolver.webappRootAbsolute;
    public static final String webappLibAbsolute = PathSolver.webappLibAbsolute;
    public static final String CLASSES_PATH = "classes/";
    public static final String WEBINF_PATH = "WEB-INF/";
    private String jarName;
    private static AtomicBoolean deployedStatus = new AtomicBoolean(false);

    private JarDeployer() {
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public static final JarDeployer getWebappLibInstance(String jarName) {
        WebAppLibJarDeployer webappLibJarDeployer = new WebAppLibJarDeployer();
        webappLibJarDeployer.setJarName(jarName);
        return webappLibJarDeployer;
    }

    public Object deploy() {
        String _srcPath = this.getSourcePath();
        String _destPath = this.getDestinationPath();
        logger.debug("##############################################");
        logger.debug("getSourcePath() = " + _srcPath);
        logger.debug("getDestinationPath() = " + _destPath);
        logger.debug("##############################################");
        if (_srcPath != null && _destPath != null) {
            return this.deploy(_srcPath, _destPath);
        }
        return null;
    }

    public Object deploy(String srcPath, String destinationPath) {
        Object _srcPath = this.getSourcePath();
        String _destPath = this.getDestinationPath();
        logger.debug("deploy --> getSourcePath() = " + (String)_srcPath);
        if (_srcPath == null) {
            _srcPath = srcPath;
        }
        if (_srcPath == null) {
            throw new NullPointerException("srcPath is required.");
        }
        if (_destPath == null) {
            _destPath = destinationPath;
        }
        if (_destPath == null) {
            throw new NullPointerException("destinationPath is required.");
        }
        if (!((String)_srcPath).trim().endsWith("/")) {
            _srcPath = (String)_srcPath + "/";
        }
        _srcPath = (String)_srcPath + this.jarName;
        _srcPath = FileSystemUtils.trimFileSchema((String)_srcPath);
        _destPath = FileSystemUtils.trimFileSchema(_destPath);
        logger.debug("\u8981\u89e3\u538b\u7684jar\u6587\u4ef6\u662f\uff1a" + (String)_srcPath);
        logger.debug("\u76ee\u7684\u8def\u5f84                       \uff1a" + _destPath);
        try {
            this.decompress((String)_srcPath, _destPath);
        }
        catch (Error e) {
            throw new Error("\u90e8\u7f72\u6587\u4ef6\u5931\u8d25! \t\u53ef\u80fd\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u4e0d\u7b26\u5408jar\u6587\u4ef6\u89c4\u8303\u3002", e);
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void decompress(String fileName, String outputPath) {
        File dir;
        if (!((String)outputPath).endsWith(File.separator)) {
            outputPath = (String)outputPath + File.separator;
        }
        if (!(dir = new File((String)outputPath)).exists()) {
            dir.mkdirs();
        }
        JarFile jf = null;
        String outFileName = null;
        try {
            jf = new JarFile(fileName);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                if (je == null) continue;
                if (je.getName().indexOf("META-INF") >= 0) {
                    logger.debug("\u5ffd\u7565META-INF\u76ee\u5f55");
                    continue;
                }
                outFileName = (String)outputPath + je.getName();
                File f = new File(outFileName);
                if (je.isDirectory()) {
                    if (f.exists()) continue;
                    f.mkdirs();
                    continue;
                }
                File pf = f.getParentFile();
                if (!pf.exists()) {
                    pf.mkdirs();
                }
                InputStream in = null;
                OutputStream out = null;
                try {
                    in = jf.getInputStream(je);
                    if (in == null) {
                        logger.error("......InputStream is null,\u672a\u53d1\u73b0\u5bf9\u8c61,je: " + je.getName());
                        continue;
                    }
                    out = new BufferedOutputStream(new FileOutputStream(f));
                    byte[] buffer = new byte[2048];
                    int nBytes = 0;
                    while ((nBytes = in.read(buffer)) > 0) {
                        out.write(buffer, 0, nBytes);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    logger.error("\u590d\u5236\u6587\u4ef6\u53d1\u751f\u9519\u8bef: " + je.getName() + ", " + ex.getMessage());
                }
                finally {
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String s = "\u89e3\u538b" + outFileName + "\u51fa\u9519, " + e.getMessage();
            logger.error(s);
            throw new Error(s, e);
        }
        finally {
            if (jf != null) {
                try {
                    logger.info("jar file is closed: " + jf.getName());
                    jf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public abstract String getSourcePath();

    public abstract String getDestinationPath();

    public static String getWebLibPath() {
        return FileSystemUtils.trimFileSchema(JarDeployer.combinLibByClasspath());
    }

    static String combinLibByClasspath() {
        int classesStartInx = classpathAbsolute.lastIndexOf(CLASSES_PATH);
        int classesEndInx = classesStartInx + 8;
        StringBuilder p = new StringBuilder(classpathAbsolute);
        p.delete(classesStartInx, classesEndInx);
        p.append("lib/");
        return p.toString();
    }

    public static final boolean getDeployedStatus() {
        return deployedStatus.get();
    }

    public static boolean checkDeployStatus(String deployJarPrefix) {
        List<File> availableJars = JarDeployer.getMatchDeployedJars(deployJarPrefix);
        if (StringUtils.isEmptyList(availableJars)) {
            deployedStatus.compareAndSet(false, true);
            return deployedStatus.get();
        }
        ClassPathResource deployFile = new ClassPathResource(DEPLOY_FILENAME);
        if (deployFile.exists()) {
            Properties deployProperties = new Properties();
            try {
                deployProperties.load(deployFile.getInputStream());
            }
            catch (IOException e) {
                throw new ApplicationRuntimeException("\u52a0\u8f7d\u6587\u4ef6:'walker-deploy.properties' \u51fa\u73b0\u5f02\u5e38", e);
            }
            String jarName = null;
            for (File jarFile : availableJars) {
                jarName = jarFile.getName();
                if (deployProperties.containsKey(jarName)) {
                    logger.debug("=============> \u627e\u5230\u4e86\u4e00\u4e2a\u5339\u914d\u7684(\u90e8\u7f72\u8fc7)jar: " + jarName);
                    DEPLOYED_FILES.put(jarName, Long.parseLong(deployProperties.getProperty(jarName)));
                    continue;
                }
                logger.debug("-------------> \u627e\u5230\u4e00\u4e2a\u672a\u66f4\u65b0\u7684jar,\u8bb0\u5f55\u5e76\u5728\u540e\u7eed\u89e3\u538b:" + jarName);
                DEPLOY_WAIT_FILES.add(jarFile);
            }
            if (DEPLOY_WAIT_FILES.size() > 0) {
                return false;
            }
            deployedStatus.compareAndSet(false, true);
            return deployedStatus.get();
        }
        try {
            JarDeployer.createEmptyFile(classpathAbsolute + DEPLOY_FILENAME);
            for (File jarFile : availableJars) {
                DEPLOY_WAIT_FILES.add(jarFile);
            }
            return false;
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("\u521b\u5efa\u90e8\u7f72\u6587\u4ef6\u5931\u8d25\uff0c\u7cfb\u7edf\u542f\u52a8\u6ca1\u6709\u6210\u529f", e);
        }
    }

    public static final void createEmptyFile(String filepath) throws IOException {
        File file = new File(filepath);
        if (!file.exists()) {
            file.createNewFile();
        } else {
            System.out.println("file exist: " + filepath);
        }
    }

    private static File[] getAppLibFiles() {
        File appLibFolder = new File(webappLibAbsolute);
        return appLibFolder.listFiles();
    }

    public static List<File> getMatchDeployedJars(String deployJarPrefix) {
        File[] jarList = JarDeployer.getAppLibFiles();
        if (jarList != null) {
            ArrayList<File> result = new ArrayList<File>(8);
            for (File f : jarList) {
                if (!f.getName().startsWith(deployJarPrefix)) continue;
                logger.debug("\u627e\u5230\u4e86\u5339\u914d\u7684jar: " + f.getName());
                result.add(f);
            }
            return result;
        }
        return null;
    }

    public static final void updateDeployedJarTimestamp() throws Exception {
        if (DEPLOY_WAIT_FILES.size() > 0) {
            ClassPathResource deployFile = new ClassPathResource(DEPLOY_FILENAME);
            Properties deployProperties = new Properties();
            try {
                deployProperties.load(deployFile.getInputStream());
            }
            catch (IOException e) {
                throw new ApplicationRuntimeException("\u52a0\u8f7d\u6587\u4ef6:'walker-deploy.properties' \u51fa\u73b0\u5f02\u5e38", e);
            }
            long timestamp = 0L;
            for (File f : DEPLOY_WAIT_FILES) {
                JarDeployer jarDeployer = JarDeployer.getWebappLibInstance(f.getName());
                jarDeployer.deploy();
                timestamp = System.currentTimeMillis();
                deployProperties.setProperty(f.getName(), String.valueOf(timestamp));
                DEPLOYED_FILES.put(f.getName(), timestamp);
            }
            deployProperties.store(new FileWriter(new File(classpathAbsolute + DEPLOY_FILENAME)), "\u66f4\u65b0\u8bb0\u5f55");
        }
        DEPLOY_WAIT_FILES.clear();
        deployedStatus.compareAndSet(false, true);
    }

    public static final List<Properties> getJarRootResources(String jarFileName, String resourcePrefix) {
        if (StringUtils.isEmpty(jarFileName)) {
            return null;
        }
        ArrayList<Properties> propertiesList = new ArrayList<Properties>(2);
        JarFile jf = null;
        try {
            jf = new JarFile(jarFileName);
            JarEntry je = null;
            Properties properties = null;
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                je = e.nextElement();
                if (je == null || je.isDirectory() || !je.getName().startsWith(resourcePrefix)) continue;
                logger.debug("\u627e\u5230\u4e86\u9700\u8981\u7684entry: " + je.getName());
                properties = new Properties();
                properties.load(jf.getInputStream(je));
                propertiesList.add(properties);
            }
            ArrayList<Properties> arrayList = propertiesList;
            return arrayList;
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("\u52a0\u8f7dJAR\u4e2d\u7684\u6587\u4ef6\u51fa\u73b0\u9519\u8bef: " + jarFileName, e);
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println(classpathAbsolute);
        System.out.println(webappRootAbsolute);
        JarDeployer.getJarRootResources("d:/logs/walkersoft-flow-v1.0.jar", "app_");
    }

    private static class WebAppLibJarDeployer
    extends JarDeployer {
        private String sourcePath;
        private String destinationPath;

        @Override
        public String getSourcePath() {
            if (this.sourcePath == null) {
                this.sourcePath = WebAppLibJarDeployer.combinLibByClasspath();
            }
            return this.sourcePath;
        }

        @Override
        public String getDestinationPath() {
            if (this.destinationPath == null) {
                int classesStartInx = classpathAbsolute.lastIndexOf(JarDeployer.CLASSES_PATH);
                this.destinationPath = classpathAbsolute.substring(0, classesStartInx) + "pages/ftl/";
            }
            return this.destinationPath;
        }
    }

    private static class PathSolver {
        static String classpathAbsolute = PathSolver.getClasspathAbsolute();
        static String webappRootAbsolute = PathSolver.getWebAppRootAbsolute(classpathAbsolute);
        static String webappLibAbsolute = PathSolver.getWebAppLibAbsolute(classpathAbsolute);

        private PathSolver() {
        }

        static final String getClasspathAbsolute() {
            ClassPathResource cpr = new ClassPathResource(".");
            try {
                return FileSystemUtils.trimFileSchema(cpr.getURL().toString());
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                throw new Error("classpath solver error! cause = " + e);
            }
        }

        static final String getWebAppRootAbsolute(String classpathAbs) {
            if (StringUtils.isNotEmpty(classpathAbs)) {
                return classpathAbs.replaceFirst("WEB-INF/classes/", "");
            }
            return null;
        }

        static final String getWebAppLibAbsolute(String classpathAbs) {
            if (StringUtils.isNotEmpty(classpathAbs)) {
                return classpathAbs.replaceFirst(JarDeployer.CLASSES_PATH, "lib/");
            }
            return null;
        }
    }
}

