/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class LongCalendar {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy/MM/dd");
    private static final String FILE_SEPARATOR = "/";
    public static final String[] weekDefine = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};

    public static long getLongCalendar() {
        try {
            long longCalendar = 0L;
            Calendar cldCurrent = Calendar.getInstance();
            String strYear = String.valueOf(cldCurrent.get(1));
            Object strMonth = String.valueOf(cldCurrent.get(2));
            Object strDate = String.valueOf(cldCurrent.get(5));
            if (((String)strMonth).length() < 2) {
                strMonth = "0" + (String)strMonth;
            }
            if (((String)strDate).length() < 2) {
                strDate = "0" + (String)strDate;
            }
            longCalendar = Long.parseLong(strYear + (String)strMonth + (String)strDate);
            return longCalendar += 100L;
        }
        catch (Exception Exp) {
            return 0L;
        }
    }

    public static String toString(long canlendar) {
        return LongCalendar.toString(canlendar, FILE_SEPARATOR);
    }

    public static String toString(long canlendar, String separator) {
        try {
            if (canlendar == 0L) {
                return "";
            }
            StringBuffer sbCalendar = new StringBuffer();
            sbCalendar.insert(0, canlendar);
            if (sbCalendar.length() == 8) {
                sbCalendar.insert(6, separator);
                sbCalendar.insert(4, separator);
            } else if (sbCalendar.length() == 14) {
                sbCalendar.insert(12, ":");
                sbCalendar.insert(10, ":");
                sbCalendar.insert(8, " ");
                sbCalendar.insert(6, separator);
                sbCalendar.insert(4, separator);
            } else {
                return "";
            }
            return sbCalendar.toString();
        }
        catch (Exception Exp) {
            return "";
        }
    }

    public static long getLongTime() {
        try {
            long longCalendar = 0L;
            Calendar cldCurrent = Calendar.getInstance();
            String strYear = String.valueOf(cldCurrent.get(1));
            Object strMonth = String.valueOf(cldCurrent.get(2) + 1);
            Object strDate = String.valueOf(cldCurrent.get(5));
            Object strHour = String.valueOf(cldCurrent.get(10));
            String strAM_PM = String.valueOf(cldCurrent.get(9));
            Object strMinute = String.valueOf(cldCurrent.get(12));
            Object strSecond = String.valueOf(cldCurrent.get(13));
            if (strAM_PM.equals("1")) {
                strHour = String.valueOf(Long.parseLong((String)strHour) + 12L);
            }
            if (((String)strMonth).length() < 2) {
                strMonth = "0" + (String)strMonth;
            }
            if (((String)strDate).length() < 2) {
                strDate = "0" + (String)strDate;
            }
            if (((String)strHour).length() < 2) {
                strHour = "0" + (String)strHour;
            }
            if (((String)strMinute).length() < 2) {
                strMinute = "0" + (String)strMinute;
            }
            if (((String)strSecond).length() < 2) {
                strSecond = "0" + (String)strSecond;
            }
            longCalendar = Long.parseLong(strYear + (String)strMonth + (String)strDate + (String)strHour + (String)strMinute + (String)strSecond);
            return longCalendar;
        }
        catch (Exception Exp) {
            return 0L;
        }
    }

    public static String getDateStringByLongDatetime(long longCalendar) {
        try {
            String StrCalendar = String.valueOf(longCalendar);
            Object StrCalendarResult = "";
            if (StrCalendar.length() == 8) {
                StrCalendarResult = StrCalendar.substring(0, 4) + "\u5e74" + StrCalendar.substring(4, 6) + "\u6708" + StrCalendar.substring(6, 8) + "\u65e5";
                return StrCalendarResult;
            }
            if (StrCalendar.length() == 14) {
                StrCalendarResult = StrCalendar.substring(0, 4) + "\u5e74" + StrCalendar.substring(4, 6) + "\u6708" + StrCalendar.substring(6, 8) + "\u65e5";
                StrCalendarResult = (String)StrCalendarResult + " " + StrCalendar.substring(8, 10) + ":" + StrCalendar.substring(10, 12) + ":" + StrCalendar.substring(12, 14);
                return StrCalendarResult;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getDateStringByLongDatetimeForPage(long longCalendar) {
        try {
            String StrCalendar = String.valueOf(longCalendar);
            Object StrCalendarResult = "";
            if (StrCalendar.length() == 8) {
                StrCalendarResult = StrCalendar.substring(0, 4) + FILE_SEPARATOR + StrCalendar.substring(4, 6) + FILE_SEPARATOR + StrCalendar.substring(6, 8);
                return StrCalendarResult;
            }
            if (StrCalendar.length() == 14) {
                StrCalendarResult = StrCalendar.substring(0, 4) + FILE_SEPARATOR + StrCalendar.substring(4, 6) + FILE_SEPARATOR + StrCalendar.substring(6, 8);
                StrCalendarResult = (String)StrCalendarResult + " " + StrCalendar.substring(8, 10) + ":" + StrCalendar.substring(10, 12);
                return StrCalendarResult;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getCurrentDate() {
        return LongCalendar.getDateStringByLongDatetimeForPage(LongCalendar.getLongCalendar());
    }

    public static long longCalender(String strCalender, String strFGF) {
        long longCal;
        block6: {
            longCal = 0L;
            try {
                if (strCalender != null && !strCalender.equals("")) {
                    String[] calendars = strCalender.split(strFGF);
                    if (calendars.length == 3) {
                        String strYear = calendars[0];
                        Object strMon = calendars[1];
                        Object strDay = calendars[2];
                        if (((String)strMon).length() == 1) {
                            strMon = "0" + (String)strMon;
                        }
                        if (((String)strDay).length() == 1) {
                            strDay = "0" + (String)strDay;
                        }
                        longCal = Long.parseLong(strYear + (String)strMon + (String)strDay);
                    }
                    break block6;
                }
                return 0L;
            }
            catch (Exception ex) {
                return 0L;
            }
        }
        return longCal;
    }

    public static long toLongCalendar(String strCalender, String strFGF) {
        long longCal;
        block6: {
            longCal = 0L;
            try {
                if (strCalender != null && !strCalender.equals("")) {
                    String[] calendars = (strCalender = strCalender.replace(" ", "").replace(":", "")).split(strFGF);
                    if (calendars.length == 3) {
                        String strYear = calendars[0];
                        Object strMon = calendars[1];
                        Object strDay = calendars[2];
                        if (((String)strMon).length() == 1) {
                            strMon = "0" + (String)strMon;
                        }
                        if (((String)strDay).length() == 7) {
                            strDay = "0" + (String)strDay;
                        }
                        longCal = Long.parseLong(strYear + (String)strMon + (String)strDay);
                    }
                    break block6;
                }
                return 0L;
            }
            catch (Exception ex) {
                return 0L;
            }
        }
        return longCal;
    }

    public static String getCurrentDateView() {
        Calendar cldCurrent = Calendar.getInstance();
        String strYear = String.valueOf(cldCurrent.get(1));
        Object strMonth = String.valueOf(cldCurrent.get(2) + 1);
        Object strDate = String.valueOf(cldCurrent.get(5));
        if (((String)strMonth).length() < 2) {
            strMonth = "0" + (String)strMonth;
        }
        if (((String)strDate).length() < 2) {
            strDate = "0" + (String)strDate;
        }
        String StrCurrentCalendar = strYear + FILE_SEPARATOR + (String)strMonth + FILE_SEPARATOR + (String)strDate;
        return StrCurrentCalendar;
    }

    public static final String getCurrentMonth() {
        Calendar cldCurrent = Calendar.getInstance();
        return cldCurrent.get(1) + FILE_SEPARATOR + (cldCurrent.get(2) + 1) + FILE_SEPARATOR;
    }

    public static String getCurrentDateView(long longCalendar) {
        if (longCalendar == 0L) {
            return "";
        }
        String strDateView = String.valueOf(longCalendar);
        String strYear = strDateView.substring(0, 4);
        Object strMonth = strDateView.substring(4, 6);
        Object strDate = strDateView.substring(6, 8);
        if (((String)strMonth).length() < 2) {
            strMonth = "0" + (String)strMonth;
        }
        if (((String)strDate).length() < 2) {
            strDate = "0" + (String)strDate;
        }
        String StrCurrentCalendar = strYear + FILE_SEPARATOR + (String)strMonth + FILE_SEPARATOR + (String)strDate;
        return StrCurrentCalendar;
    }

    public static long addMonth(long calendar, int month) {
        try {
            long longDate = 0L;
            if (!LongCalendar.checkCalendar(calendar)) {
                return -1L;
            }
            int intYear = Integer.parseInt(String.valueOf(calendar).substring(0, 4));
            int intMonth = Integer.parseInt(String.valueOf(calendar).substring(4, 6)) - 1;
            int intDate = Integer.parseInt(String.valueOf(calendar).substring(6));
            GregorianCalendar gCalendar = new GregorianCalendar(intYear, intMonth, intDate);
            gCalendar.add(2, month);
            longDate = (long)gCalendar.get(1) * 10000L + (long)(gCalendar.get(2) + 1) * 100L + (long)gCalendar.get(5);
            return longDate;
        }
        catch (Exception Exp) {
            return -1L;
        }
    }

    public static boolean checkCalendar(long calendar) {
        try {
            return true;
        }
        catch (Exception Exp) {
            return false;
        }
    }

    public static String getTimeStringByLongTime(long longCalendar) {
        return LongCalendar.getTimeStringByLongTime(longCalendar, true);
    }

    public static String getTimeStringByLongTime(long longCalendar, boolean formatCn) {
        try {
            String StrCalendar = String.valueOf(longCalendar);
            if (StrCalendar.length() == 6) {
                StringBuilder s = new StringBuilder(StrCalendar.substring(0, 2));
                if (formatCn) {
                    s.append("\u65f6");
                } else {
                    s.append(":");
                }
                s.append(StrCalendar.substring(2, 4));
                if (formatCn) {
                    s.append("\u5206");
                } else {
                    s.append(":");
                }
                s.append(StrCalendar.substring(4, 6));
                if (formatCn) {
                    s.append("\u79d2");
                }
                return s.toString();
            }
            throw new RuntimeException("\u8bf7\u8f93\u51656\u4f4d\u6570\u7684\u65e5\u671f");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8f6c\u6362\u65e5\u671f\u683c\u5f0f\u9519\u8bef: " + e.getMessage());
        }
    }

    public static long getCalendarByMonthAdd(long longCalendar, int num) {
        try {
            Date date = sdf.parse(Long.toString(longCalendar), new ParsePosition(0));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(2, num);
            return Long.parseLong(sdf.format(calendar.getTime()));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static long getCalendarByYearAdd(long longCalendar, int num) {
        try {
            Date date = sdf.parse(Long.toString(longCalendar));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(1, num);
            return Long.parseLong(sdf.format(calendar.getTime()));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String getCurrentDateForpage() {
        return LongCalendar.getDateStringByLongDatetime(LongCalendar.getLongCalendar());
    }

    public static String getCalendarAfterDays(int daysNumber) {
        Calendar now = Calendar.getInstance();
        now.add(5, daysNumber);
        return sdf2.format(now.getTime());
    }

    public static String getCalendarAfterDays(long longDate, int daysNumber) {
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(longDate);
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        calendar.set(year, month, day);
        calendar.add(5, daysNumber);
        return sdf2.format(calendar.getTime());
    }

    public static Date toDate(long longDate) {
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(longDate);
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        calendar.set(year, month, day);
        return calendar.getTime();
    }

    public static Date toDateTime(long longDate) {
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(longDate);
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        int hour = Integer.parseInt(strDate.substring(8, 10));
        int minute = Integer.parseInt(strDate.substring(10, 12));
        int second = Integer.parseInt(strDate.substring(12, 14));
        calendar.set(year, month, day, hour, minute, second);
        return calendar.getTime();
    }

    public static String toTimeLineTime(long longDate) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("MMM dd yyyy", Locale.ENGLISH);
        SimpleDateFormat sdfTime = new SimpleDateFormat("MMM dd yyyy HH:mm:ss", Locale.ENGLISH);
        String formatData = String.valueOf(longDate).length() > 8 ? sdfTime.format(LongCalendar.toDateTime(longDate)) : sdfDate.format(LongCalendar.toDate(longDate));
        return formatData;
    }

    public static String toTimeLineTime(String strDate) {
        long longDate = Long.parseLong(strDate);
        SimpleDateFormat sdfDate = new SimpleDateFormat("MMM dd yyyy", Locale.ENGLISH);
        SimpleDateFormat sdfTime = new SimpleDateFormat("MMM dd yyyy HH:mm:ss", Locale.ENGLISH);
        String formatData = String.valueOf(longDate).length() > 8 ? sdfTime.format(LongCalendar.toDateTime(longDate)) : sdfDate.format(LongCalendar.toDate(longDate));
        return formatData;
    }

    public static String toDayOfWeek(long longDate) {
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(longDate);
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        calendar.set(year, month, day);
        int index = calendar.get(7) - 1;
        return weekDefine[index];
    }

    public static int whichDayOfWeek(long longDate) {
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(longDate);
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        calendar.set(year, month, day);
        int whichDay = calendar.get(7);
        if (whichDay == 1) {
            return 7;
        }
        return whichDay - 1;
    }

    public static long getDays(String begin, String end) {
        try {
            Date begin1 = sdf.parse(begin);
            Date end1 = sdf.parse(end);
            return (end1.getTime() - begin1.getTime()) / 86400000L;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static long getDateAfterAddDateNum(long date, int amount) {
        try {
            Date begin = sdf.parse(String.valueOf(date));
            Calendar currentDate = Calendar.getInstance();
            currentDate.setTime(begin);
            currentDate.add(5, amount);
            String dateStr = sdf.format(currentDate.getTime());
            return Long.parseLong(dateStr);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static long getFirstDayOfWeek(long _cntDate) {
        int whichDay = LongCalendar.whichDayOfWeek(_cntDate);
        return LongCalendar.getDateAfterAddDateNum(_cntDate, -whichDay + 1);
    }

    public static long getLastDayOfWeek(long _firstDate) {
        return LongCalendar.getDateAfterAddDateNum(_firstDate, 6);
    }

    protected static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int getLastDayOfMonth(int monthNum, int year) {
        switch (monthNum) {
            case 1: {
                return 31;
            }
            case 2: {
                return LongCalendar.isLeapYear(year) ? 29 : 28;
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        throw new IllegalArgumentException("Illegal month number: " + monthNum);
    }

    public static void main(String[] args) {
        String s = "2012/07/13 09:11:33";
        System.out.println(LongCalendar.toLongCalendar(s, FILE_SEPARATOR));
        System.out.println(LongCalendar.getTimeStringByLongTime(130529L));
    }
}

