/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStreamUtils {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStreamUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectToFile(String filePath, Object obj) {
        File file = new File(filePath);
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(obj);
        }
        catch (FileNotFoundException e) {
            logger.error("saveObjectToFile():File not found! filePath = " + filePath);
            throw new com.walker.infrastructure.core.FileNotFoundException(e);
        }
        catch (IOException e) {
            logger.error("File save error!");
            e.printStackTrace();
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObjectFromFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        ObjectInputStream ois = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            file.delete();
            Object object = ois.readObject();
            return object;
        }
        catch (FileNotFoundException e) {
            logger.warn("File not found in readObject!");
            Object var5_11 = null;
            return var5_11;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

