/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import com.walker.infrastructure.utils.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PhoneNumberUtils {
    public static final String REGEX_MOBILE_REPLACE = "$1****$2";
    public static final String REGEX_MOBILE_MASK = "(\\d{3})\\d{4}(\\d{4})";
    public static final String REGEX_MOBILEPHONE = "^0?1[3456789]\\d{9}$";
    public static final String REGEX_FIXEDPHONE = "^(010|02\\d|0[3-9]\\d{2})?\\d{6,8}$";
    public static final String REGEX_ZIPCODE = "^(010|02\\d|0[3-9]\\d{2})\\d{6,8}$";
    private static final Pattern PATTERN_FIXEDPHONE = Pattern.compile("^(010|02\\d|0[3-9]\\d{2})?\\d{6,8}$");
    private static final Pattern PATTERN_MOBILEPHONE = Pattern.compile("^0?1[3456789]\\d{9}$");
    private static final Pattern PATTERN_ZIPCODE = Pattern.compile("^(010|02\\d|0[3-9]\\d{2})\\d{6,8}$");

    public static String maskMobile(String phone) {
        if (StringUtils.isEmpty(phone)) {
            return "";
        }
        return phone.replaceAll(REGEX_MOBILE_MASK, REGEX_MOBILE_REPLACE);
    }

    public static final boolean isFixedPhoneNumber(String number) {
        Matcher match = PATTERN_FIXEDPHONE.matcher(number);
        return match.matches();
    }

    public static final boolean isCellPhoneNumber(String number) {
        Matcher match = PATTERN_MOBILEPHONE.matcher(number);
        return match.matches();
    }

    public static final String getZipFromHomephone(String strNumber) {
        Matcher matcher = PATTERN_ZIPCODE.matcher(strNumber);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

