/*
 * Decompiled with CFR 0.152.
 */
package com.walker.location;

public class DistanceUtils {
    private static final double PI = Math.PI;
    private static final double R = 6371229.0;

    public static final double getDistance(double longt1, double lat1, double longt2, double lat2) {
        double x = (longt2 - longt1) * Math.PI * 6371229.0 * Math.cos((lat1 + lat2) / 2.0 * Math.PI / 180.0) / 180.0;
        double y = (lat2 - lat1) * Math.PI * 6371229.0 / 180.0;
        return Math.hypot(x, y);
    }

    public static final double getFlatDistance(double longt1, double lat1, double longt2, double lat2) {
        double _x = Math.abs(longt1 - longt2);
        double _y = Math.abs(lat1 - lat2);
        return Math.sqrt(_x * _x + _y * _y);
    }

    public static void main(String[] args) {
        double destLon = 121.541924;
        double destLat = 31.272223;
        System.out.println("d1 = " + DistanceUtils.getDistance(121.537369, 31.278162, destLon, destLat));
        System.out.println("\u5e73\u9762\u8ddd\u79bb d1 = " + DistanceUtils.getFlatDistance(121.537369, 31.278162, destLon, destLat));
        long startTime = System.nanoTime();
        System.out.println("d2 = " + DistanceUtils.getDistance(121.557634, 31.312228, destLon, destLat));
        System.out.println("d2 \u82b1\u8d39\u65f6\u95f4\uff1a" + (System.nanoTime() - startTime));
        startTime = System.nanoTime();
        System.out.println("\u5e73\u9762\u8ddd\u79bb d2 = " + DistanceUtils.getFlatDistance(121.557634, 31.312228, destLon, destLat));
        System.out.println("d2\u5e73\u9762 \u82b1\u8d39\u65f6\u95f4\uff1a" + (System.nanoTime() - startTime));
        startTime = System.nanoTime();
        System.out.println("d3 = " + DistanceUtils.getDistance(121.557634, 31.312228, 121.537369, 31.278162));
        System.out.println("d3\u5e73\u9762 \u82b1\u8d39\u65f6\u95f4\uff1a" + (System.nanoTime() - startTime));
        System.out.println("\u5e73\u9762\u8ddd\u79bb d3 = " + DistanceUtils.getFlatDistance(121.557634, 31.312228, 121.537369, 31.278162));
    }
}

