/*
 * Decompiled with CFR 0.152.
 */
package com.walker.push;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushException;
import com.walker.push.PushManager;
import com.walker.push.PushResult;
import com.walker.push.PushStatusListener;
import com.walker.push.Pushable;
import com.walker.push.Strategy;
import com.walker.push.util.PushUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPushManager
implements PushManager {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private PushStatusListener pushStatusListener;
    private List<String> messageChannelNames = new ArrayList<String>(4);
    private boolean messageParallel = false;
    private List<Strategy> strategyList = null;
    private Map<String, List<Pushable>> pushableMap = new HashMap<String, List<Pushable>>(8);
    private Map<String, Pushable> pushIdMap = new HashMap<String, Pushable>(8);

    @Override
    public void register(Pushable pushable) {
        if (pushable == null) {
            throw new IllegalArgumentException("\u6ce8\u518c\u9519\u8bef\uff1a\u63a8\u9001\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        NotificationChannel channel = pushable.getNotificationChannel();
        List<Pushable> pushableList = this.pushableMap.get(channel.getIndex());
        if (StringUtils.isEmptyList(pushableList)) {
            pushableList = new ArrayList<Pushable>(2);
            this.pushableMap.put(channel.getIndex(), pushableList);
        }
        if (pushableList.contains(pushable)) {
            throw new IllegalArgumentException("\u63a8\u9001\u8005\u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u6ce8\u518c\uff0cname=" + pushable.getName());
        }
        pushableList.add(pushable);
        this.pushIdMap.put(pushable.getId(), pushable);
        if (this.pushStatusListener == null) {
            throw new IllegalArgumentException("pushStatusListener \u672a\u8bbe\u7f6e!");
        }
        if (pushable.supportAsync() && pushable.getPushStatusListener() == null) {
            pushable.setPushStatusListener(this.pushStatusListener);
        }
        this.logger.info("\u6ce8\u518c'\u63a8\u9001\u8005':{}", (Object)pushable.getName());
    }

    @Override
    public PushResult push(Notification notification, String pushableId) {
        if (notification == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u63a8\u9001\u7a7a\u6d88\u606f");
        }
        List<NotificationChannel> channelList = notification.getChannelList();
        if (StringUtils.isEmptyList(channelList)) {
            throw new IllegalArgumentException("'notification'\u4e2d\u4e0d\u5b58\u5728\u901a\u9053\u4fe1\u606f\uff0c\u65e0\u6cd5\u63a8\u9001");
        }
        if (this.strategyList != null) {
            for (Strategy strategy : this.strategyList) {
                if (strategy.access(notification)) continue;
                return this.createFailedPushResult(-1, "\u901a\u77e5\u672a\u901a\u8fc7\u7b56\u7565\u68c0\u67e5\uff0c\u65e0\u6cd5\u63a8\u9001", null);
            }
        }
        List<Pushable> pushableList = null;
        Pushable pushable = null;
        PushResult pushResult = null;
        boolean multipleChannelParallel = notification.getParallel();
        int channelSize = channelList.size();
        for (NotificationChannel channel : channelList) {
            pushableList = this.pushableMap.get(channel.getIndex());
            if (StringUtils.isEmptyList(pushableList)) {
                if (channelSize == 1) {
                    this.logger.warn("\u53ea\u6709\u4e00\u4e2a\u901a\u9053\uff0c\u4f46\u4e5f\u672a\u914d\u7f6e\u63a8\u9001\u8005\uff0c\u63a8\u9001\u5931\u8d25:{}", (Object)notification);
                    return PushUtils.acquireFailedPushResult("\u901a\u9053\u4e0d\u5b58\u5728", StringUtils.collectionToDelimitedString(notification.getReceiverList(), ","));
                }
                if (!multipleChannelParallel) {
                    this.logger.debug("\u5b58\u5728\u591a\u901a\u9053\uff0c\u4ec5\u53d1\u9001\u4e00\u4e2a\u6210\u529f\u5373\u53ef\uff0c\u901a\u9053\u4e0d\u5b58\u5728\uff0c\u7ee7\u7eed\u627e\u4e0b\u4e00\u4e2a");
                    continue;
                }
                this.logger.error("\u901a\u9053\u4e0d\u5b58\u5728\uff0c\u53d1\u9001\u5931\u8d25\u4e00\u4e2a:{}", (Object)channel.getIndex());
                continue;
            }
            try {
                pushable = StringUtils.isNotEmpty(pushableId) && pushableList.size() > 1 ? this.pushIdMap.get(pushableId) : pushableList.get(0);
                if (pushable.supportAsync()) {
                    this.logger.debug("\u5f02\u6b65\u63a8\u9001\uff0cPushManager\u4e0d\u76f4\u63a5\u8fd4\u56de\u7ed3\u679c\uff0c\u9700\u8981\u5728\u76d1\u542c\u5668\u4e2d\u5b9e\u73b0!");
                    pushable.push(notification);
                    if (multipleChannelParallel) continue;
                    return PushUtils.acquireSuccessPushResult();
                }
                pushResult = this.pushOnce(pushableList, notification);
                if (multipleChannelParallel) continue;
                return PushUtils.acquireSuccessPushResult();
            }
            catch (PushException e) {
                throw new RuntimeException("\u63a8\u9001\u4e00\u6b21\u5931\u8d25:" + e.getMessage() + ", id=" + e.getMessageId(), e);
            }
        }
        this.logger.info("\u8fd9\u91cc\u9700\u8981\u8fd4\u56de\u7ec4\u5408\u597d\u7684'\u63a8\u9001\u7ed3\u679c'\uff0c\u540e\u7eed\u5b8c\u5584\uff0c\u6682\u65f6\u4e3a\u7a7a");
        return pushResult;
    }

    protected PushResult pushOnce(List<Pushable> pushableList, Notification notification) throws PushException {
        return this.invokePush(pushableList.get(0), notification);
    }

    protected PushResult invokePush(Pushable pushable, Notification notification) throws PushException {
        PushResult pushResult = pushable.push(notification);
        if (pushResult == null) {
            throw new IllegalStateException("\u63a8\u9001\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u5b9e\u73b0'push'\u65b9\u6cd5!", null);
        }
        if (!StringUtils.isEmptyList(pushResult.getFailedList())) {
            this.logger.error("\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff0cid={}, failed={}", (Object)notification.getId(), pushResult.getFailedList());
            if (!notification.getBroadcast()) {
                ArrayList<String> successList = new ArrayList<String>(8);
                for (String one : notification.getReceiverList()) {
                    boolean inFailedList = false;
                    for (String failed : pushResult.getFailedList()) {
                        if (!failed.equals(one)) continue;
                        inFailedList = true;
                        break;
                    }
                    if (inFailedList) continue;
                    successList.add(one);
                }
                if (!StringUtils.isEmptyList(successList)) {
                    this.persistent(notification, successList, pushable.getNotificationChannel());
                    this.logger.debug("\u4fdd\u5b58\u4e86\uff08\u90e8\u5206\uff09\u6210\u529f\u63a8\u9001\u96c6\u5408");
                }
                this.persistentFailed(notification, pushResult.getFailedList(), pushable.getNotificationChannel());
            }
        } else {
            this.persistent(notification, notification.getReceiverList(), pushable.getNotificationChannel());
            this.logger.debug("\u4fdd\u5b58\u4e86\uff08\u5168\u90e8\uff09\u6210\u529f\u63a8\u9001\u96c6\u5408");
        }
        return pushResult;
    }

    @Override
    public PushResult push(List<Notification> list) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addStrategy(Strategy strategy) {
        if (this.strategyList == null) {
            this.strategyList = new ArrayList<Strategy>(2);
        }
        if (this.strategyList.contains(strategy)) {
            throw new IllegalArgumentException("\u7b56\u7565\u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u6ce8\u518c");
        }
        this.strategyList.add(strategy);
        this.logger.info("\u6ce8\u518c'\u7b56\u7565':{}", (Object)strategy.getId());
    }

    @Override
    public List<Pushable> getPushList() {
        ArrayList<Pushable> list = new ArrayList<Pushable>(8);
        for (List<Pushable> onePushList : this.pushableMap.values()) {
            for (Pushable pushable : onePushList) {
                list.add(pushable);
            }
        }
        return list;
    }

    @Override
    public List<Pushable> getPushList(NotificationChannel channel) {
        return this.pushableMap.get(channel.getIndex());
    }

    @Override
    public Pushable getPushObject(String id) {
        return this.pushIdMap.get(id);
    }

    @Override
    public void setAsyncListener(PushStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is required!");
        }
        this.pushStatusListener = listener;
    }

    protected abstract void persistent(Notification var1, List<String> var2, NotificationChannel var3);

    protected abstract void persistentFailed(Notification var1, List<String> var2, NotificationChannel var3);

    private PushResult createFailedPushResult(int code, String text, List<String> failedList) {
        PushResult pushResult = new PushResult();
        pushResult.setCode(code);
        pushResult.setText(text);
        pushResult.setFailedList(failedList);
        return pushResult;
    }

    @Override
    public boolean isMessageParallel() {
        return this.messageParallel;
    }

    @Override
    public List<String> getMessageChannelNames() {
        return this.messageChannelNames;
    }

    public void setMessageParallel(boolean messageParallel) {
        this.messageParallel = messageParallel;
    }

    public void setMessageChannelNames(List<String> messageChannelNames) {
        this.messageChannelNames = messageChannelNames;
    }

    protected PushStatusListener getAsyncListener() {
        return this.pushStatusListener;
    }
}

