/*
 * Decompiled with CFR 0.152.
 */
package com.walker.push;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushException;
import com.walker.push.PushResult;
import com.walker.push.PushStatusListener;
import com.walker.push.Pushable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPushObject<T>
implements Pushable<T> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private PushStatusListener pushStatusListener;
    private boolean supportAsync = false;
    private String id;
    private String name;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PushResult push(Notification notification) throws PushException {
        if (notification == null) {
            throw new IllegalArgumentException("\u63a8\u9001\u6d88\u606f\u672a\u63d0\u4f9b");
        }
        if (StringUtils.isEmpty(notification.getContent()) || StringUtils.isEmptyList(notification.getChannelList())) {
            throw new IllegalArgumentException("\u63a8\u9001\u6d88\u606f\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        if (!notification.getBroadcast() && StringUtils.isEmptyList(notification.getReceiverList())) {
            throw new IllegalArgumentException("\u975e\u5e7f\u64ad\u63a8\u9001\u5fc5\u987b\u6307\u5b9a\u63a5\u6536\u8005");
        }
        boolean hasChannel = false;
        for (NotificationChannel channel : notification.getChannelList()) {
            if (channel != this.getNotificationChannel()) continue;
            hasChannel = true;
            break;
        }
        if (!hasChannel) {
            throw new PushException(notification.getId(), "\u5f53\u524d\u6d88\u606f\u4e0d\u652f\u6301\u8be5\u63a8\u9001\u8005\uff1a" + this.name, null);
        }
        List list = this.translateToTarget(notification);
        if (StringUtils.isEmptyList(list)) {
            this.logger.warn("translateToTarget():\u8f6c\u6362\u8fd4\u56de\u7a7a\u5bf9\u8c61");
        }
        if (this.supportAsync && this.pushStatusListener == null) {
            throw new IllegalStateException("\u5f02\u6b65\u63a8\u9001\uff0c\u9700\u8981\u5148\u6dfb\u52a0\uff1apushStatusListener");
        }
        PushResult pushResult = this.doPushContent(notification, list);
        return pushResult;
    }

    protected abstract PushResult doPushContent(Notification var1, List<T> var2) throws PushException;

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        Pushable push;
        if (obj == null) {
            return false;
        }
        return obj instanceof Pushable && (push = (Pushable)obj).getId().equals(this.id);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean supportAsync() {
        return this.supportAsync;
    }

    public void setSupportAsync(boolean supportAsync) {
        this.supportAsync = supportAsync;
    }

    @Override
    public PushStatusListener getPushStatusListener() {
        return this.pushStatusListener;
    }

    @Override
    public void setPushStatusListener(PushStatusListener pushStatusListener) {
        this.pushStatusListener = pushStatusListener;
    }
}

