/*
 * Decompiled with CFR 0.152.
 */
package com.walker.push.support;

import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.PhoneNumberUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.AbstractPushObject;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.SmsMessage;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSmsPush
extends AbstractPushObject<SmsMessage> {
    @Override
    public NotificationChannel getNotificationChannel() {
        return NotificationChannel.Sms;
    }

    @Override
    public List<SmsMessage> translateToTarget(Notification notification) {
        ArrayList<SmsMessage> data = new ArrayList<SmsMessage>(4);
        SmsMessage smsMessage = new SmsMessage();
        String userPhoneNum = null;
        for (String user : notification.getReceiverList()) {
            userPhoneNum = PhoneNumberUtils.isCellPhoneNumber(user) ? user : this.getUserMobile(user);
            if (StringUtils.isEmpty(userPhoneNum)) {
                this.logger.warn("\u672a\u67e5\u627e\u5230\u7528\u6237\u624b\u673a\u53f7\uff0cuser = {}", (Object)user);
                continue;
            }
            smsMessage.addMobile(userPhoneNum);
        }
        try {
            SmsMessage message = JsonUtils.jsonStringToObject(notification.getContent(), SmsMessage.class);
            smsMessage.setTemplateId(message.getTemplateId());
            smsMessage.setTemplateParam(message.getTemplateParam());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6d88\u606f\u5185\u5bb9json\u8f6c\u6362\u9519\u8bef:" + e.getMessage(), e);
        }
        data.add(smsMessage);
        return data;
    }

    protected abstract String getUserMobile(String var1);
}

