/*
 * Decompiled with CFR 0.152.
 */
package com.walker.push.util;

import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushResult;
import java.util.ArrayList;
import java.util.List;

public class PushUtils {
    public static final String FROM_MOBILE = "\u5e73\u53f0\u53f7\u7801";

    public static final Notification acquireSmsNotification(String title, String content, String targetUser, String creator) {
        ArrayList<String> targetMobileList = new ArrayList<String>(2);
        targetMobileList.add(targetUser);
        ArrayList<NotificationChannel> channels = new ArrayList<NotificationChannel>(2);
        channels.add(NotificationChannel.Sms);
        return PushUtils.acquireNotification(title, content, FROM_MOBILE, targetMobileList, creator, true, channels, false);
    }

    public static final Notification acquireSmsNotification(String title, String content, List<String> targetList, String creator, boolean persistent) {
        ArrayList<NotificationChannel> channels = new ArrayList<NotificationChannel>(2);
        channels.add(NotificationChannel.Sms);
        return PushUtils.acquireNotification(title, content, FROM_MOBILE, targetList, creator, persistent, channels, false);
    }

    public static final Notification acquireEmailNotificationOne(String title, String content, String from, String targetMail, String creator) {
        ArrayList<String> targetMailList = new ArrayList<String>(2);
        targetMailList.add(targetMail);
        return PushUtils.acquireEmailNotification(title, content, from, targetMailList, creator, true);
    }

    public static final Notification acquireEmailNotification(String title, String content, String from, List<String> targetMailList, String creator, boolean persistent) {
        ArrayList<NotificationChannel> channels = new ArrayList<NotificationChannel>(2);
        channels.add(NotificationChannel.Mail);
        return PushUtils.acquireNotification(title, content, from, targetMailList, creator, persistent, channels, false);
    }

    public static final Notification acquireNotification(String title, String content, String from, List<String> targetList, String creator, boolean persistent, List<NotificationChannel> channelList, boolean parallel) {
        Notification notification = new Notification();
        notification.setId(NumberGenerator.getLongSequenceId());
        notification.setTitle(title);
        notification.setContent(content);
        notification.setPersistent(persistent);
        notification.setFrom(from);
        notification.setCreateTime(DateUtils.getDateTimeNumber());
        notification.setChannelList(channelList);
        notification.setReceiverList(targetList);
        notification.setCreator(creator);
        notification.setParallel(parallel);
        return notification;
    }

    public static final PushResult acquireSuccessPushResult() {
        PushResult pushResult = new PushResult();
        pushResult.setText("success");
        return pushResult;
    }

    public static final PushResult acquireFailedPushResult(String msg, String userId) {
        PushResult pushResult = new PushResult();
        pushResult.setCode(-1);
        pushResult.setText(msg);
        pushResult.addOneFailed(userId);
        return pushResult;
    }
}

