/*
 * Decompiled with CFR 0.152.
 */
package com.walker.spider;

import com.walker.infrastructure.utils.KeyValue;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.spider.TextParse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueParse
implements TextParse<List<KeyValue<String, String>>, List<String>> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String delimiter;

    @Override
    public String getDelimiter() {
        return null;
    }

    @Override
    public List<KeyValue<String, String>> parse(Object content, List<String> option) {
        if (content == null || StringUtils.isEmpty(content.toString())) {
            throw new IllegalArgumentException("content is required!");
        }
        String data = content.toString().trim();
        String[] rows = data.split(this.delimiter);
        this.logger.debug("\u5206\u9694\u540e\u5171\u6709 {} \u884c", (Object)rows.length);
        ArrayList<KeyValue<String, String>> resultList = new ArrayList<KeyValue<String, String>>();
        String[] keyValueStr = null;
        for (String text : rows) {
            if (StringUtils.isEmpty(text = text.trim()) || text.equals(this.delimiter)) {
                this.logger.warn("\u5b58\u5728\u7a7a\u884c\uff0c\u6216\u53ea\u6709\u5206\u9694\u7b26:{}", (Object)this.delimiter);
                continue;
            }
            if (text.indexOf("http://") > 0 || text.indexOf("https://") > 0) {
                String key = this.findKeyWithHttps(option, text);
                if (StringUtils.isEmpty(key)) {
                    this.logger.error("\u884c\u6570\u636e\u6ca1\u6709\u627e\u5230\u6709\u6548 key\uff0crow = {}", (Object)text);
                    continue;
                }
                String value = text.replaceFirst(key + ":", "").trim();
                keyValueStr = new String[]{key, value};
            } else {
                keyValueStr = text.trim().split(":");
            }
            if (keyValueStr.length == 1) {
                this.logger.debug("\u8be5\u884c\u53ea\u6709\u4e00\u4e2a\u503c\uff0c\u53ef\u80fd\u6ca1\u6709value\uff0ckey = {}", (Object)keyValueStr[0]);
                resultList.add(new KeyValue<String, String>(keyValueStr[0], ""));
                continue;
            }
            if (keyValueStr.length == 2) {
                resultList.add(new KeyValue<String, String>(keyValueStr[0], keyValueStr[1].trim()));
                continue;
            }
            this.logger.error("\u6570\u636e\u884c\u9519\u8bef:{}", (Object)text);
        }
        if (option != null) {
            KeyValue kv = null;
            Iterator it = resultList.iterator();
            while (it.hasNext()) {
                kv = (KeyValue)it.next();
                if (option.contains(kv.getKey())) {
                    this.logger.debug("\u5305\u542b\u8981\u7684\u6570\u636e\uff0ckey={}, value={}", kv.getKey(), kv.getValue());
                    continue;
                }
                it.remove();
            }
        }
        return resultList;
    }

    private String findKeyWithHttps(List<String> option, String row) {
        for (String key : option) {
            if (row.indexOf(key + ":") < 0) continue;
            this.logger.debug("\u627e\u5230\u4e86 key = {}", (Object)key);
            return key;
        }
        return null;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

