package com.walker.jdbc;

import org.springframework.jdbc.core.RowMapper;

import java.io.Serializable;
import java.util.Map;

/**
 * mapper基础类，定义mapper具有的方法
 * 时克英 2022/08/12
 */
public interface BaseMapper<T> extends RowMapper<T>, Serializable, Cloneable {
    /**
     * 获取Insert语句及参数
     *
     * @return Insert语句及参数
     */
    SqlAndParameters<Map<String, Object>> getInsertSql_();

    /**
     * 根据主键获取update语句及参数
     *
     * @return update语句及参数
     */
    SqlAndParameters<Map<String, Object>> getUpdateSql_();

    /**
     * 根据条件及参数获取update语句及参数
     *
     * @param where      更新语句片段，条件部分
     * @param parameters 更新条件参数
     * @return update语句及参数
     */
    SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters);

    /**
     * 根据条件及参数获取update语句及参数
     *
     * @param where      更新语句片段，条件部分
     * @param parameters 更新条件参数
     * @return update语句及参数
     */
    SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters);

    /**
     * 根据主键获取删除语句及参数
     *
     * @return 删除语句及参数
     */
    SqlAndParameters<Map<String, Object>> getDeleteSql_();

    /**
     * 根据条件及参数组装删除语句
     *
     * @param where      条件
     * @param parameters 参数
     * @return 删除语句及参数
     */
    SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters);

    /**
     * 根据条件及参数组装删除语句
     *
     * @param where      条件
     * @param parameters 参数
     * @return 删除语句及参数
     */
    SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters);

    /**
     * 根据主键获取查询语句及条件
     *
     * @return 查询语句及条件
     */
    SqlAndParameters<Map<String, Object>> getSingleSql_();

    /**
     * 根据条件及参数获取查询语句
     *
     * @param where      查询条件
     * @param parameters 参数对象
     * @return 查询语句及条件
     */
    SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters);

    /**
     * 根据条件及参数获取查询语句
     *
     * @param where      查询条件
     * @param parameters 参数对象
     * @return 查询语句及条件
     */
    SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters);

    /**
     * 获取表名
     *
     * @return 表名
     */
    String getTableName_();

    /**
     * 获取主键名称
     *
     * @return 主键名称
     */
    String getPkName_();

    /**
     * 获取主键值
     *
     * @return 主键值
     */
    Object getPkValue_();

    /**
     * 设置主键值
     *
     * @param value 主键值
     */
    void setPkValue(Object value);

}
