package com.walker.jdbc.sqlgen;

import com.walker.jdbc.SqlAndParameters;

import java.util.Map;

/**
 * sql 生成工具类基类
 *
 * @author 时克英
 * @date 2017年3月3日
 */
public abstract class AbstractSqlBuilder {
    /**
     * 根据主键生成sql语句
     *
     * @return sql语句及参数
     */
    public abstract SqlAndParameters<Map<String, Object>> genMapSql();

    /**
     * <pre>
     * 根据条件和条件参数生成sql语句
     * 例如：
     *   genMapSql("where name = :name", new Map{name:"lizhihui"})
     * </pre>
     *
     * @param where         条件片段
     * @param parametersMap 条件参数
     * @return sql语句及参数
     */
    public abstract SqlAndParameters<Map<String, Object>> genMapSql(String where, Map<String, Object> parametersMap);

    /**
     * 根据主键生成sql语句
     *
     * @return sql语句及参数
     */
    public abstract SqlAndParameters<Object[]> genArraySql();

    /**
     * <pre>
     * 根据条件和条件参数生成sql语句
     * 例如：
     *   genArraySql("where name = ?", new Object[]{"lizhihui"})
     * </pre>
     *
     * @param where           条件片段
     * @param parametersArray 条件参数
     * @return sql语句及参数
     */
    public abstract SqlAndParameters<Object[]> genArraySql(String where, Object[] parametersArray);

    /**
     * 判断对象是否为空或是空串
     *
     * @param value 参数值
     * @return 是否为空或是空串
     */
    protected boolean isSqlNull(Object value) {
        return value == null || "".equals(value);
    }

    /**
     * 过滤空字符串
     *
     * @param value 参数值
     * @return 过滤后的参数值
     */
    protected Object getNotEmptyValue(Object value) {
        if (isSqlNull(value)) {
            return null;
        } else {
            return value;
        }
    }
}
