package com.walker.jdbc.sqlgen;

import java.util.HashMap;
import java.util.Map;

/**
 * SQL片段生成工具
 */
public class SqlFragmentBuilder {
    private StringBuffer sql;
    private Map<String, Object> parameters;

    public SqlFragmentBuilder() {
        this.sql = new StringBuffer();
        this.parameters = new HashMap<>();
    }

    public SqlFragmentBuilder(String sql) {
        this.sql = new StringBuffer(sql);
        this.parameters = new HashMap<>();
    }

    /**
     * 如果value不为空，添加sql片段fragment
     *
     * @param fragment  SQL片段
     * @param parameter sql参数名
     * @param value     sql参数值
     */
    public void add(String fragment, String parameter, Object value) {
        if (value != null && !"".equals(value)) {
            this.sql.append(" ").append(fragment);
            this.parameters.put(parameter, value);
        }
    }

    /**
     * 如果enable，添加sql片段fragment
     *
     * @param fragment  SQL片段
     * @param parameter sql参数名
     * @param value     sql参数值
     * @param enable    是否启用SQL片段
     */
    public void add(String fragment, String parameter, Object value, boolean enable) {
        if (enable) {
            this.sql.append(" ").append(fragment);
            this.parameters.put(parameter, value);
        }
    }

    /**
     * 如果value不全为空，添加sql片段fragment
     *
     * @param fragment   SQL片段
     * @param parameter1 sql参数名1
     * @param value1     sql参数值1
     * @param parameter2 sql参数名2
     * @param value2     sql参数值2
     */
    public void add(String fragment, String parameter1, Object value1, String parameter2, Object value2) {
        if (value1 != null || value2 != null) {
            this.sql.append(" ").append(fragment);
            this.parameters.put(parameter1, value1);
            this.parameters.put(parameter2, value2);
        }
    }

    /**
     * 如果enable，添加sql片段fragment
     *
     * @param fragment   SQL片段
     * @param parameter1 sql参数名1
     * @param value1     sql参数值1
     * @param parameter2 sql参数名2
     * @param value2     sql参数值2
     * @param enable     是否启用SQL片段
     */
    public void add(String fragment, String parameter1, Object value1, String parameter2, Object value2, boolean enable) {
        if (enable) {
            this.sql.append(" ").append(fragment);
            this.parameters.put(parameter1, value1);
            this.parameters.put(parameter2, value2);
        }
    }

    /**
     * 如果value不全为空，添加sql片段fragment
     *
     * @param fragment   SQL片段
     * @param parameter1 sql参数名1
     * @param value1     sql参数值1
     * @param parameter2 sql参数名2
     * @param value2     sql参数值2
     * @param parameter3 sql参数名3
     * @param value3     sql参数值3
     */
    public void add(String fragment, String parameter1, Object value1, String parameter2, Object value2, String parameter3, Object value3) {
        if (value1 != null || value2 != null || value3 != null) {
            this.sql.append(" ").append(fragment);
            this.parameters.put(parameter1, value1);
            this.parameters.put(parameter2, value2);
            this.parameters.put(parameter3, value3);
        }
    }

    /**
     * 如果enable，添加sql片段fragment
     *
     * @param fragment   SQL片段
     * @param parameter1 sql参数名1
     * @param value1     sql参数值1
     * @param parameter2 sql参数名2
     * @param value2     sql参数值2
     * @param parameter3 sql参数名3
     * @param value3     sql参数值3
     * @param enable     是否启用SQL片段
     */
    public void add(String fragment, String parameter1, Object value1, String parameter2, Object value2, String parameter3, Object value3, boolean enable) {
        if (enable) {
            this.sql.append(" ").append(fragment);
            this.parameters.put(parameter1, value1);
            this.parameters.put(parameter2, value2);
            this.parameters.put(parameter3, value3);
        }
    }

    /**
     * 添加sql片段
     *
     * @param fragment
     * @return
     */
    public void add(String fragment) {
        this.sql.append(" ").append(fragment);
    }

    /**
     * 获取sql片段
     *
     * @return
     */
    public String getFragment() {
        return sql.toString();
    }

    /**
     * 获取sql片段，删除前导and
     *
     * @return
     */
    public String getNoLeadingAndFragment() {
        return sql.toString().replaceAll("^(?i) *and", "");
    }

    /**
     * 获取参数对象
     *
     * @return
     */
    public Map<String, Object> getParameters() {
        return parameters;
    }

    @Override
    public String toString() {
        return new StringBuilder(sql).append(", parameters=").append(this.parameters).toString();
//        return ToStringBuilder.reflectionToString(this);
    }
}
