/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.jdbc.dao.PersistenceException;
import com.walker.jdbc.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryVo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SPACE = " ";
    private static final String PERCENT = "%";
    private static final String LIKE = " like ";
    private static final String AND = " and ";
    private static final String OR = " or ";
    private static final String EQUAL = " = ";
    private static final String UNEQUAL = " != ";
    private static final String IN = " in ";
    private static final String NOTIN = " not in ";
    private static final String GREATER = " >= ";
    private static final String LESS = " <= ";
    private static final String WHERE = " where ";
    private static final String ORDER_BY = " order by ";
    private Map<String, Object> equalItem = new SaveIdentityHashMap<String, Object>();
    private Map<String, Object> likeItem = new SaveIdentityHashMap<String, Object>();
    private Map<String, Object> greaterItem = new SaveIdentityHashMap<String, Object>();
    private Map<String, Object> lessItem = new SaveIdentityHashMap<String, Object>();
    private Map<String, Object> unequalItem;
    private Map<String, Object> includeItem;
    private Map<String, Object> notincludeItem;
    private Map<String, Object> defalutSuffixItem;
    private Integer sfzsgd;
    private Map<String, Object> countMap = new SaveIdentityHashMap<String, Object>();
    private List keyList;
    private StringBuilder extSql;
    private StringBuilder orderBySql;
    private String qvSortName = null;
    private String qvSortOrder = null;
    private String toggleColumnValue = "";
    private Map<String, Object> queryMap;
    private String serializeQuery = "";
    private Map<String, Object> excludeQueryVO;
    private List<Map<String, Object>> labelCount;
    private static Pattern p = Pattern.compile("^[A-Za-z0-9_\\.]+$");

    public QueryVo() {
        this.unequalItem = new SaveIdentityHashMap<String, Object>();
        this.includeItem = new SaveIdentityHashMap<String, Object>();
        this.notincludeItem = new SaveIdentityHashMap<String, Object>();
        this.defalutSuffixItem = new HashMap<String, Object>();
        this.excludeQueryVO = new HashMap<String, Object>();
        this.keyList = new ArrayList();
        this.labelCount = new ArrayList<Map<String, Object>>();
        this.queryMap = new HashMap<String, Object>();
        this.extSql = new StringBuilder();
        this.orderBySql = new StringBuilder();
    }

    public StringBuffer generateAndSql() {
        return this.generateAndSql(false);
    }

    public StringBuffer generateAndSql(boolean generateWhere) {
        StringBuffer whereQuery = new StringBuffer(SPACE);
        boolean paramEmpty = true;
        paramEmpty = this.genSql(this.equalItem, whereQuery, paramEmpty, EQUAL, false, generateWhere, this.keyList, this.countMap);
        paramEmpty = this.genSql(this.likeItem, whereQuery, paramEmpty, LIKE, true, generateWhere, this.keyList, this.countMap);
        paramEmpty = this.genSql(this.greaterItem, whereQuery, paramEmpty, GREATER, false, generateWhere, this.keyList, this.countMap);
        paramEmpty = this.genSql(this.lessItem, whereQuery, paramEmpty, LESS, false, generateWhere, this.keyList, this.countMap);
        paramEmpty = this.genSql(this.unequalItem, whereQuery, paramEmpty, UNEQUAL, false, generateWhere, this.keyList, this.countMap);
        paramEmpty = this.genSql(this.includeItem, whereQuery, paramEmpty, IN, false, generateWhere, this.keyList, this.countMap);
        paramEmpty = this.genSql(this.notincludeItem, whereQuery, paramEmpty, NOTIN, false, generateWhere, this.keyList, this.countMap);
        if (!this.extSql.toString().equals("")) {
            if (generateWhere && paramEmpty) {
                whereQuery.append(WHERE).append((CharSequence)this.extSql);
            } else {
                whereQuery.append(AND).append((CharSequence)this.extSql);
            }
        }
        if (this.excludeQueryVO.size() == 0) {
            if (StringUtils.isNotEmpty(this.qvSortName)) {
                if (StringUtils.isNotEmpty(this.qvSortOrder)) {
                    whereQuery.append(ORDER_BY + this.qvSortName + SPACE + this.qvSortOrder);
                }
            } else if (StringUtils.isNotEmpty(this.orderBySql.toString())) {
                whereQuery.append(SPACE).append((CharSequence)this.orderBySql);
            }
        }
        return whereQuery.append(SPACE);
    }

    private boolean genSql(Map<String, Object> item, StringBuffer whereQuery, boolean paramEmpty, String operator, boolean like, boolean generateWhere, List keyList, Map<String, Object> countMap) {
        boolean flag_in = operator.equals(IN) || operator.equals(NOTIN);
        for (Map.Entry<String, Object> entry : item.entrySet()) {
            Object value;
            if (this.excludeQueryVO.containsKey(entry.getKey())) continue;
            Object key = "";
            if (keyList.contains(entry.getKey())) {
                if (!countMap.containsKey(entry.getKey())) {
                    countMap.put(entry.getKey(), 0);
                } else {
                    countMap.put(entry.getKey(), countMap.get(entry.getKey() + "1"));
                }
                key = entry.getKey() + "_" + countMap.get(entry.getKey());
            } else {
                keyList.add(entry.getKey());
                key = entry.getKey();
            }
            if (!StringUtils.isNotEmpty(String.valueOf(entry.getValue())) || String.valueOf(entry.getValue()).equalsIgnoreCase("[]")) continue;
            if (flag_in) {
                if (generateWhere && paramEmpty) {
                    whereQuery.append(WHERE + entry.getKey() + operator + "(:" + (String)key + ")");
                    generateWhere = false;
                } else {
                    whereQuery.append(AND + entry.getKey() + operator + "(:" + (String)key + ")");
                }
                value = new ArrayList();
                if (entry.getValue().toString().startsWith("[") && entry.getValue().toString().endsWith("]")) {
                    try {
                        int i;
                        ArrayNode arrayNode = JsonUtils.toJsonArray((String)entry.getValue().toString());
                        if (arrayNode.size() > 0 && arrayNode.get(0).toString().startsWith(";") && arrayNode.get(0).toString().endsWith(";")) {
                            for (i = 0; i < arrayNode.size(); ++i) {
                                String v = arrayNode.get(i).toString();
                                value.add((String)v.substring(1, v.length() - 1));
                            }
                        }
                        for (i = 0; i < arrayNode.size(); ++i) {
                            value.add((String)arrayNode.get(i).toString());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    if (entry.getValue().toString().startsWith(";") && entry.getValue().toString().endsWith(";")) {
                        List<String> templist = Arrays.asList(String.valueOf(entry.getValue()).trim().split(","));
                        for (String tv : templist) {
                            value.add((String)tv.substring(1, tv.length() - 1));
                        }
                    } else {
                        value = Arrays.asList(String.valueOf(entry.getValue()).trim().split(","));
                    }
                    value.remove("");
                }
                this.queryMap.put((String)key, value);
                continue;
            }
            if (generateWhere && paramEmpty) {
                whereQuery.append(WHERE + entry.getKey() + operator + ":" + (String)key);
            } else {
                whereQuery.append(AND + entry.getKey() + operator + ":" + (String)key);
            }
            value = "";
            value = like ? PERCENT + String.valueOf(entry.getValue()).trim() + PERCENT : (this.defalutSuffixItem.containsKey(key) ? String.valueOf(entry.getValue()).trim() + this.defalutSuffixItem.get(key) : String.valueOf(entry.getValue()).trim());
            paramEmpty = false;
            this.queryMap.put((String)key, value);
        }
        return paramEmpty;
    }

    public Map<String, Object> getQueryMap() {
        return this.queryMap;
    }

    public void appendOrderBySql(String orderBySqlOnce) {
        this.orderBySql.append(orderBySqlOnce);
    }

    public void appendExtSql(String extSqlonce) {
        this.extSql.append(extSqlonce);
    }

    public void addEqualItem(String key, Object value) {
        this.equalItem.put(key, value);
    }

    public void addLikeItem(String key, Object value) {
        this.likeItem.put(key, value);
    }

    public void addIncludeItem(String key, Object value) {
        this.includeItem.put(key, value);
    }

    public void initIncludeItem(String key, Object value) {
        this.includeItem.put(key, ";" + value + ";");
    }

    public void addLessItem(String key, Object value) {
        this.lessItem.put(key, value);
    }

    public void addGreaterItem(String key, Object value) {
        this.greaterItem.put(key, value);
    }

    public void addUnequalItem(String key, Object value) {
        this.unequalItem.put(key, value);
    }

    public void addQueryMap(String key, Object value) {
        this.queryMap.put(key, value);
    }

    public void addQueryMap(Map map) {
        this.queryMap.putAll(map);
    }

    public Object getEqualItemValue(String key) {
        return this.getObject(this.equalItem, key);
    }

    public Object getIncludeItemValue(String key) {
        return this.getObject(this.includeItem, key);
    }

    public Object getLikeItemValue(String key) {
        return this.getObject(this.likeItem, key);
    }

    private Object getObject(Map<String, Object> item, String key) {
        for (Map.Entry<String, Object> entry : item.entrySet()) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, Object> getEqualItem() {
        return this.equalItem;
    }

    public void setEqualItem(Map<String, Object> equalItem) {
        this.equalItem = equalItem;
    }

    public Map<String, Object> getLikeItem() {
        return this.likeItem;
    }

    public void setLikeItem(Map<String, Object> likeItem) {
        this.likeItem = likeItem;
    }

    public String getToggleColumnValue() {
        return this.toggleColumnValue;
    }

    public void setToggleColumnValue(String toggleColumnValue) {
        this.toggleColumnValue = toggleColumnValue;
    }

    public String getSerializeQuery() {
        return this.serializeQuery;
    }

    public void setSerializeQuery(String serializeQuery) {
        this.serializeQuery = serializeQuery;
    }

    public Map<String, Object> getLessItem() {
        return this.lessItem;
    }

    public void setLessItem(Map<String, Object> lessItem) {
        this.lessItem = lessItem;
    }

    public Map<String, Object> getGreaterItem() {
        return this.greaterItem;
    }

    public void setGreaterItem(Map<String, Object> greaterItem) {
        this.greaterItem = greaterItem;
    }

    public Map<String, Object> getUnequalItem() {
        return this.unequalItem;
    }

    public void setUnequalItem(Map<String, Object> unequalItem) {
        this.unequalItem = unequalItem;
    }

    public Map<String, Object> getIncludeItem() {
        return this.includeItem;
    }

    public void setIncludeItem(Map<String, Object> includeItem) {
        this.includeItem = includeItem;
    }

    public Map<String, Object> getNotincludeItem() {
        return this.notincludeItem;
    }

    public void setNotincludeItem(Map<String, Object> notincludeItem) {
        this.notincludeItem = notincludeItem;
    }

    public Map<String, Object> getDefalutSuffixItem() {
        return this.defalutSuffixItem;
    }

    public void setDefalutSuffixItem(Map<String, Object> defalutSuffixItem) {
        this.defalutSuffixItem = defalutSuffixItem;
    }

    public void addExcludeQueryVO(String key, Object value) {
        this.excludeQueryVO.put(key, value);
    }

    public Map<String, Object> getExcludeQueryVO() {
        return this.excludeQueryVO;
    }

    public void clearExcludeQueryVO() {
        this.excludeQueryVO.clear();
        this.keyList.clear();
        this.countMap.clear();
    }

    public List<Map<String, Object>> getLabelCount() {
        return this.labelCount;
    }

    public void setLabelCount(List<Map<String, Object>> labelCount) {
        this.labelCount = labelCount;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public String getQvSortName() {
        return this.qvSortName;
    }

    public void setQvSortName(String qvSortName) {
        if (!this.columnCheck(qvSortName)) {
            throw new PersistenceException(qvSortName + "\u4e3a\u975e\u6cd5\u7684\u5c5e\u6027\u503c");
        }
        this.qvSortName = qvSortName;
    }

    public String getQvSortOrder() {
        return this.qvSortOrder;
    }

    public void setQvSortOrder(String qvSortOrder) {
        if (StringUtils.isNotEmpty(qvSortOrder) && !qvSortOrder.equalsIgnoreCase("DESC") && !qvSortOrder.equalsIgnoreCase("ASC")) {
            throw new PersistenceException(this.qvSortName + "\u4e3a\u975e\u6cd5\u7684\u5173\u952e\u5b57");
        }
        this.qvSortOrder = qvSortOrder;
    }

    public Integer getSfzsgd() {
        if (this.sfzsgd == null) {
            this.sfzsgd = 0;
        }
        return this.sfzsgd;
    }

    public void setSfzsgd(Integer sfzsgd) {
        this.sfzsgd = sfzsgd;
    }

    private boolean columnCheck(String column) {
        if (column == null || column.isEmpty()) {
            return true;
        }
        Matcher m = p.matcher(column);
        return m.matches();
    }

    class SaveIdentityHashMap<K, V>
    extends IdentityHashMap<K, V> {
        SaveIdentityHashMap() {
        }

        @Override
        public V put(K k, V v) {
            if (!QueryVo.this.columnCheck(k.toString())) {
                throw new PersistenceException(k + "\u4e3a\u975e\u6cd5\u7684\u5c5e\u6027\u540d");
            }
            return super.put(k, v);
        }
    }
}

