/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ResultSetUtils {
    private Map<String, Integer> columnMap;

    public int findColumn(ResultSet rs, String column) throws SQLException {
        if (this.columnMap == null) {
            this.columnMap = new HashMap<String, Integer>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            for (int index = 1; index <= columnCount; ++index) {
                this.columnMap.put(this.lookupColumnName(rsmd, index).toUpperCase(), index);
            }
        }
        Integer columnIndex = null;
        columnIndex = this.columnMap.get(column.toUpperCase());
        if (columnIndex == null) {
            columnIndex = -1;
        }
        return columnIndex;
    }

    private String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String name = resultSetMetaData.getColumnLabel(columnIndex);
        if (name != null && !name.isEmpty()) {
            name = resultSetMetaData.getColumnName(columnIndex);
        }
        return name;
    }
}

