/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc;

import com.walker.jdbc.util.StringSqlUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlAndParameters<T>
implements Serializable {
    public static final long serialVersionUID = 123456787654321L;
    private final String sql;
    private final T parameters;
    private static final Pattern MAP_PARAMETER_PLACEHOLDER = Pattern.compile(":([a-zA-Z_][a-zA-Z0-9_\\.]*)");
    private static final Pattern ARRAY_PARAMETER_PLACEHOLDER = Pattern.compile("\\?");
    private static final Logger logger = LoggerFactory.getLogger(SqlAndParameters.class);

    public SqlAndParameters(String sql, T parameters) {
        this.sql = sql;
        this.parameters = parameters;
    }

    public String getSql() {
        return this.sql;
    }

    public T getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.sql + "\r\n" + this.parameters;
    }

    public String toPrintSql() {
        if (this.parameters == null) {
            return this.sql;
        }
        try {
            if (this.parameters instanceof Map) {
                Matcher matcher = MAP_PARAMETER_PLACEHOLDER.matcher(this.sql);
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    if (((Map)this.parameters).containsKey(matcher.group(1))) {
                        String value = this.getSqlParamString(((Map)this.parameters).get(matcher.group(1)));
                        matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
                        continue;
                    }
                    matcher.appendReplacement(sb, matcher.group());
                }
                matcher.appendTail(sb);
                return sb.toString();
            }
            if (this.parameters.getClass().isArray()) {
                Matcher matcher = ARRAY_PARAMETER_PLACEHOLDER.matcher(this.sql);
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (matcher.find()) {
                    String value = this.getSqlParamString(Array.get(this.parameters, i++));
                    matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
                }
                matcher.appendTail(sb);
                return sb.toString();
            }
            return this.sql;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.toString();
        }
    }

    private String getSqlParamString(Object value) {
        if (value == null || "".equals(value)) {
            return "null";
        }
        if (value instanceof String || value instanceof Date) {
            return "'" + StringSqlUtils.escapeSql(value.toString()) + "'";
        }
        return value.toString();
    }
}

