/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.sqlgen;

import java.util.HashMap;
import java.util.Map;

public class SqlFragmentBuilder {
    private StringBuffer sql;
    private Map<String, Object> parameters;

    public SqlFragmentBuilder() {
        this.sql = new StringBuffer();
        this.parameters = new HashMap<String, Object>();
    }

    public SqlFragmentBuilder(String sql) {
        this.sql = new StringBuffer(sql);
        this.parameters = new HashMap<String, Object>();
    }

    public void add(String fragment, String parameter, Object value) {
        if (value != null && !"".equals(value)) {
            this.sql.append(" ").append(fragment);
            this.parameters.put(parameter, value);
        }
    }

    public void add(String fragment, String parameter, Object value, boolean enable) {
        if (enable) {
            this.sql.append(" ").append(fragment);
            this.parameters.put(parameter, value);
        }
    }

    public void add(String fragment, String parameter1, Object value1, String parameter2, Object value2) {
        if (value1 != null || value2 != null) {
            this.sql.append(" ").append(fragment);
            this.parameters.put(parameter1, value1);
            this.parameters.put(parameter2, value2);
        }
    }

    public void add(String fragment, String parameter1, Object value1, String parameter2, Object value2, boolean enable) {
        if (enable) {
            this.sql.append(" ").append(fragment);
            this.parameters.put(parameter1, value1);
            this.parameters.put(parameter2, value2);
        }
    }

    public void add(String fragment, String parameter1, Object value1, String parameter2, Object value2, String parameter3, Object value3) {
        if (value1 != null || value2 != null || value3 != null) {
            this.sql.append(" ").append(fragment);
            this.parameters.put(parameter1, value1);
            this.parameters.put(parameter2, value2);
            this.parameters.put(parameter3, value3);
        }
    }

    public void add(String fragment, String parameter1, Object value1, String parameter2, Object value2, String parameter3, Object value3, boolean enable) {
        if (enable) {
            this.sql.append(" ").append(fragment);
            this.parameters.put(parameter1, value1);
            this.parameters.put(parameter2, value2);
            this.parameters.put(parameter3, value3);
        }
    }

    public void add(String fragment) {
        this.sql.append(" ").append(fragment);
    }

    public String getFragment() {
        return this.sql.toString();
    }

    public String getNoLeadingAndFragment() {
        return this.sql.toString().replaceAll("^(?i) *and", "");
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return new StringBuilder(this.sql).append(", parameters=").append(this.parameters).toString();
    }
}

