/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.sqlgen;

import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.AbstractSqlBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class UpdateBuilder
extends AbstractSqlBuilder {
    private final String table;
    private final List<String> setColumns = new ArrayList<String>();
    private final List<Object> setValues = new ArrayList<Object>();
    private final List<String> whereColumns = new ArrayList<String>();
    private final List<Object> whereValues = new ArrayList<Object>();

    public UpdateBuilder(String table) {
        this.table = table;
    }

    public UpdateBuilder set(String column, Object value) {
        return this.set(column, value, true);
    }

    public UpdateBuilder set(String column, Object value, boolean enable) {
        if (enable) {
            this.setColumns.add(column);
            this.setValues.add(value);
        }
        return this;
    }

    public UpdateBuilder where(String column, Object value) {
        this.whereColumns.add(column);
        this.whereValues.add(value);
        return this;
    }

    @Override
    public SqlAndParameters<Map<String, Object>> genMapSql() {
        int i;
        HashMap<Object, Object> parametersMap = new HashMap<Object, Object>();
        StringBuilder sb = new StringBuilder("update ").append(this.table);
        sb.append(" set ");
        for (i = 0; i < this.setColumns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.setColumns.get(i)).append("=:").append(this.setColumns.get(i) + "_");
            parametersMap.put(this.setColumns.get(i) + "_", this.getNotEmptyValue(this.setValues.get(i)));
        }
        sb.append(" where ");
        for (i = 0; i < this.whereColumns.size(); ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            if (this.isSqlNull(this.whereValues.get(i))) {
                sb.append(this.whereColumns.get(i)).append(" is null");
                continue;
            }
            sb.append(this.whereColumns.get(i)).append("=:").append(this.whereColumns.get(i));
            parametersMap.put(this.whereColumns.get(i), this.whereValues.get(i));
        }
        return new SqlAndParameters<Map<String, Object>>(sb.toString(), parametersMap);
    }

    @Override
    public SqlAndParameters<Map<String, Object>> genMapSql(String where, Map<String, Object> parametersMap) {
        HashMap<Object, Object> temp = new HashMap<Object, Object>();
        StringBuilder sb = new StringBuilder("update ").append(this.table);
        sb.append(" set ");
        for (int i = 0; i < this.setColumns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.setColumns.get(i)).append("=:").append(this.setColumns.get(i) + "_");
            temp.put(this.setColumns.get(i) + "_", this.getNotEmptyValue(this.setValues.get(i)));
        }
        sb.append(" ").append(where);
        temp.putAll(parametersMap);
        return new SqlAndParameters<Map<String, Object>>(sb.toString(), temp);
    }

    @Override
    public SqlAndParameters<Object[]> genArraySql(String where, Object[] parametersArray) {
        Object[] temp = new Object[]{};
        StringBuilder sb = new StringBuilder("update ").append(this.table);
        sb.append(" set ");
        for (int i = 0; i < this.setColumns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.setColumns.get(i)).append("=?");
            temp = ArrayUtils.add((Object[])temp, (Object)this.getNotEmptyValue(this.setValues.get(i)));
        }
        sb.append(" ").append(where);
        temp = ArrayUtils.addAll((Object[])temp, (Object[])parametersArray);
        return new SqlAndParameters<Object[]>(sb.toString(), temp);
    }

    @Override
    public SqlAndParameters<Object[]> genArraySql() {
        int i;
        Object[] parametersArray = new Object[]{};
        StringBuilder sb = new StringBuilder("update ").append(this.table);
        sb.append(" set ");
        for (i = 0; i < this.setColumns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.setColumns.get(i)).append("=?");
            parametersArray = ArrayUtils.add((Object[])parametersArray, (Object)this.getNotEmptyValue(this.setValues.get(i)));
        }
        sb.append(" where ");
        for (i = 0; i < this.whereColumns.size(); ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            if (this.isSqlNull(this.whereValues.get(i))) {
                sb.append(this.whereColumns.get(i)).append(" is null");
                continue;
            }
            sb.append(this.whereColumns.get(i)).append("=?");
            parametersArray = ArrayUtils.add((Object[])parametersArray, (Object)this.whereValues.get(i));
        }
        return new SqlAndParameters<Object[]>(sb.toString(), parametersArray);
    }
}

