/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.util;

import com.walker.jdbc.util.StrBuilder;
import com.walker.jdbc.util.StringUtils;

public class StringSqlUtils {
    public static final String DOUBLE_QUOTATION = "''";

    public static String escapeSql(String str) {
        return str == null ? null : StringUtils.replace(str, "'", DOUBLE_QUOTATION);
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringSqlUtils.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (StringUtils.isNotEmpty(text) && StringUtils.isNotEmpty(searchString) && replacement != null && max != 0) {
            int start = 0;
            int end = text.indexOf(searchString, start);
            if (end == -1) {
                return text;
            }
            int replLength = searchString.length();
            int increase = replacement.length() - replLength;
            int n = increase = increase < 0 ? 0 : increase;
            StrBuilder buf = new StrBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
            while (end != -1) {
                buf.append(text.substring(start, end)).append(replacement);
                start = end + replLength;
                if (--max == 0) break;
                end = text.indexOf(searchString, start);
            }
            buf.append(text.substring(start));
            return buf.toString();
        }
        return text;
    }

    public static final String getMySQLSchemaName(String serviceName) {
        if (StringUtils.isEmpty(serviceName)) {
            return null;
        }
        int index = serviceName.indexOf("?");
        if (index >= 0) {
            return serviceName.substring(0, index);
        }
        return serviceName;
    }
}

