/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;

public abstract class StringUtils {
    public static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    public static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";
    public static final char EXTENSION_SEPARATOR = '.';
    public static final char UNDERLINE = '_';
    public static final String STRING_UNDERLINE = "_";
    public static final String EMPTY_STRING = "";
    public static final String NULL_STRING = "null";
    public static final String SEPARATOR_COLON = ":";
    public static final String SEPARATOR_SEMI_COLON = ";";
    public static final String RETURN_AND_NEWLINE = "\r\n";
    public static final String DEFAULT_CHARSET_UTF8 = "UTF-8";
    public static final String SYMBOL_SEMICOLON = ";";
    public static final String SYMBOL_DOT = ".";
    public static final String CHAR_PERCENT = "%";
    public static final String CHAR_AND = "&";
    public static final String CHAR_EQUALS = "=";
    public static final String CHAR_SPACE = " ";
    public static final String SINGLE_QUOTATION = "'";
    public static final Pattern generalCharPattern = Pattern.compile("^\\w+$");
    public static final String DEFAULT_SPLIT_SEPARATOR = ",";
    private static Pattern numberPattern = Pattern.compile("[0-9]*");
    public static final String NUMBER_SET = "1234567890";
    public static final String NORMAL_SET = "1234567890abcdefghijkmnpqrstuvwxyz";

    public static final String removeBefore(String source, String separator) {
        if (StringUtils.isEmpty(source)) {
            throw new NullPointerException();
        }
        int index = source.indexOf(separator);
        if (index + 1 == source.length()) {
            throw new IllegalArgumentException("There are no content after separator char! e.g:test.abc");
        }
        if (index >= 0) {
            return source.substring(index + 1, source.length());
        }
        return source;
    }

    public static final boolean isContainValue(String[] source, String dest) {
        if (source == null) {
            return false;
        }
        for (String _s : source) {
            if (!_s.equals(dest)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isNormalChar(String text) {
        return generalCharPattern.matcher(text).matches();
    }

    public static final String cutStringLaskComma(StringBuffer sbStr) {
        if (sbStr.toString().endsWith(DEFAULT_SPLIT_SEPARATOR)) {
            sbStr.deleteCharAt(sbStr.lastIndexOf(DEFAULT_SPLIT_SEPARATOR));
        }
        return sbStr.toString();
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return StringUtils.hasLength((CharSequence)str);
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return StringUtils.hasText((CharSequence)str);
    }

    public static boolean containsWhitespace(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(String str) {
        return StringUtils.containsWhitespace((CharSequence)str);
    }

    public static String trimWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimAllWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        int index = 0;
        while (sb.length() > index) {
            if (Character.isWhitespace(sb.charAt(index))) {
                sb.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return sb.toString();
    }

    public static String trimLeadingWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == trailingCharacter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str == null || prefix == null) {
            return false;
        }
        if (str.startsWith(prefix)) {
            return true;
        }
        if (str.length() < prefix.length()) {
            return false;
        }
        String lcStr = str.substring(0, prefix.length()).toLowerCase();
        String lcPrefix = prefix.toLowerCase();
        return lcStr.equals(lcPrefix);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        if (str == null || suffix == null) {
            return false;
        }
        if (str.endsWith(suffix)) {
            return true;
        }
        if (str.length() < suffix.length()) {
            return false;
        }
        String lcStr = str.substring(str.length() - suffix.length()).toLowerCase();
        String lcSuffix = suffix.toLowerCase();
        return lcStr.equals(lcSuffix);
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public static int countOccurrencesOf(String str, String sub) {
        int idx;
        if (str == null || sub == null || str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String delete(String inString, String pattern) {
        return StringUtils.replace(inString, pattern, EMPTY_STRING);
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String quote(String str) {
        return str != null ? SINGLE_QUOTATION + str + SINGLE_QUOTATION : null;
    }

    public static Object quoteIfString(Object obj) {
        return obj instanceof String ? StringUtils.quote((String)obj) : obj;
    }

    public static String unqualify(String qualifiedName) {
        return StringUtils.unqualify(qualifiedName, '.');
    }

    public static String unqualify(String qualifiedName, char separator) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(separator) + 1);
    }

    public static String capitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, true);
    }

    public static String uncapitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, false);
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        if (capitalize) {
            sb.append(Character.toUpperCase(str.charAt(0)));
        } else {
            sb.append(Character.toLowerCase(str.charAt(0)));
        }
        sb.append(str.substring(1));
        return sb.toString();
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int sepIndex = path.lastIndexOf(46);
        return sepIndex != -1 ? path.substring(sepIndex + 1) : null;
    }

    public static String stripFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int sepIndex = path.lastIndexOf(46);
        return sepIndex != -1 ? path.substring(0, sepIndex) : path;
    }

    public static String applyRelativePath(String path, String relativePath) {
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex != -1) {
            Object newPath = path.substring(0, separatorIndex);
            if (!relativePath.startsWith(FOLDER_SEPARATOR)) {
                newPath = (String)newPath + FOLDER_SEPARATOR;
            }
            return (String)newPath + relativePath;
        }
        return relativePath;
    }

    public static Locale parseLocaleString(String localeString) {
        int endIndexOfCountryCode;
        String[] parts = StringUtils.tokenizeToStringArray(localeString, "_ ", false, false);
        String language = parts.length > 0 ? parts[0] : EMPTY_STRING;
        String country = parts.length > 1 ? parts[1] : EMPTY_STRING;
        String variant = EMPTY_STRING;
        if (parts.length >= 2 && (variant = StringUtils.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country) + country.length()))).startsWith(STRING_UNDERLINE)) {
            variant = StringUtils.trimLeadingCharacter(variant, '_');
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    public static String toLanguageTag(Locale locale) {
        return locale.getLanguage() + (String)(StringUtils.hasText(locale.getCountry()) ? "-" + locale.getCountry() : EMPTY_STRING);
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] toStringArray(Enumeration<String> enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<String> list = Collections.list(enumeration);
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String toSplit, String delimiter) {
        if (!StringUtils.hasLength(toSplit) || !StringUtils.hasLength(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtils.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return StringUtils.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (EMPTY_STRING.equals(delimiter)) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(StringUtils.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(StringUtils.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(StringUtils.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] commaDelimitedListToStringArray(String str) {
        return StringUtils.delimitedListToStringArray(str, DEFAULT_SPLIT_SEPARATOR);
    }

    public static Set<String> commaDelimitedListToSet(String str) {
        String[] tokens;
        TreeSet<String> set = new TreeSet<String>();
        for (String token : tokens = StringUtils.commaDelimitedListToStringArray(str)) {
            set.add(token);
        }
        return set;
    }

    public static boolean isEmptyList(List<?> list) {
        return list == null || list.size() == 0;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.trim().equals(EMPTY_STRING) || text.equalsIgnoreCase(NULL_STRING);
    }

    public static boolean isNotEmpty(String text) {
        return text != null && !text.trim().equals(EMPTY_STRING) && !text.equalsIgnoreCase(NULL_STRING);
    }

    public static final long[] toArray(List<Long> list) {
        if (list == null) {
            return null;
        }
        long[] result = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static String[] toArray(String val) {
        return StringUtils.stringToArray(val, DEFAULT_SPLIT_SEPARATOR);
    }

    public static String[] stringToArray(String val, String separator) {
        if (StringUtils.isEmpty(val)) {
            return null;
        }
        String[] _vals = val.split(separator);
        if (_vals.length > 0) {
            for (String s : _vals) {
                if (StringUtils.isEmpty(s)) {
                    throw new NullPointerException("empty split string: not found.");
                }
                s = s.trim();
            }
            return _vals;
        }
        return null;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericSpace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i)) || str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static Class<?> getNumbericType(String str) {
        if (StringUtils.isEmpty(str)) {
            return String.class;
        }
        int index = str.indexOf(".");
        if (index > 0) {
            boolean result;
            if (index == str.lastIndexOf(".") && str.split("\\.").length == 2 && (result = numberPattern.matcher(str.replace(".", EMPTY_STRING)).matches())) {
                return Double.class;
            }
            return String.class;
        }
        boolean result = numberPattern.matcher(str).matches();
        if (result) {
            return Long.class;
        }
        return String.class;
    }

    public static final List<String> asList(String[] arrays) {
        if (arrays == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(arrays.length);
        for (String s : arrays) {
            result.add(s);
        }
        return result;
    }

    public static final String generateRandomNumber(int length) {
        if (length > 10 || length < 0) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a1~10\u4e4b\u95f4\u7684\u503c");
        }
        StringBuilder retStr = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            double dblR = Math.random() * (double)NUMBER_SET.length();
            int intR = (int)Math.floor(dblR);
            retStr.append(NUMBER_SET.charAt(intR));
        }
        return retStr.toString();
    }
}

