package com.walker.jdbc.sqlgen;

import com.walker.jdbc.SqlAndParameters;
import org.apache.commons.lang3.ArrayUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * delete 语句生成工具
 *
 * @author 时克英
 * @date 2017年3月3日
 */
public class DeleteBuilder extends AbstractSqlBuilder {
    private final String table;
    private final List<String> columns = new ArrayList<>();
    private final List<Object> values = new ArrayList<>();

    /**
     * 根据表名创建DeleteBuilder对象
     *
     * @param table 表名
     */
    public DeleteBuilder(String table) {
        this.table = table;
    }

    /**
     * 添加where条件字段和值
     *
     * @param column 条件字段
     * @param value  条件值
     * @return DeleteBuilder
     */
    public DeleteBuilder where(String column, Object value) {
        this.columns.add(column);
        this.values.add(value);
        return this;
    }

    /**
     * @see AbstractSqlBuilder#genMapSql(String, Map< String, Object> )
     */
    @Override
    public SqlAndParameters<Map<String, Object>> genMapSql(String where, Map<String, Object> parametersMap) {
        return new SqlAndParameters<>("delete from " + this.table + " " + where, parametersMap);
    }

    /**
     * @see AbstractSqlBuilder#genArraySql(String, Object[])
     */
    @Override
    public SqlAndParameters<Object[]> genArraySql(String where, Object[] parametersArray) {
        return new SqlAndParameters<>("delete from " + this.table + " " + where, parametersArray);
    }

    /**
     * @see AbstractSqlBuilder#genMapSql()
     */
    @Override
    public SqlAndParameters<Map<String, Object>> genMapSql() {
        StringBuilder sb = new StringBuilder("delete from ").append(this.table).append(" where ");
        Map<String, Object> parametersMap = new HashMap<>();
        for (int i = 0; i < this.columns.size(); i++) {
            if (i > 0) {
                sb.append(" and ");
            }
            if (isSqlNull(this.values.get(i))) {
                sb.append(this.columns.get(i)).append(" is null");
            } else {
                sb.append(this.columns.get(i)).append("=").append(":").append(this.columns.get(i));
                parametersMap.put(this.columns.get(i), this.values.get(i));
            }
        }
        return new SqlAndParameters<>(sb.toString(), parametersMap);
    }

    /**
     * @see AbstractSqlBuilder#genArraySql()
     */
    @Override
    public SqlAndParameters<Object[]> genArraySql() {
        StringBuilder sb = new StringBuilder("delete from ").append(this.table).append(" where ");
        Object[] parametersArray = new Object[]{};
        for (int i = 0; i < this.columns.size(); i++) {
            if (i > 0) {
                sb.append(" and ");
            }
            if (isSqlNull(this.values.get(i))) {
                sb.append(this.columns.get(i)).append(" is null");
            } else {
                sb.append(this.columns.get(i)).append("=?");
                parametersArray = ArrayUtils.add(parametersArray, this.values.get(i));
            }
        }
        return new SqlAndParameters<>(sb.toString(), parametersArray);
    }
}