package com.walker.jdbc.util;

public class StringSqlUtils {

    public static final String DOUBLE_QUOTATION = "''";

    public static String escapeSql(String str) {
//        return str == null ? null : StringUtils.replace(str, "'", "''");
        return str == null ? null : StringUtils.replace(str
                , StringUtils.SINGLE_QUOTATION, DOUBLE_QUOTATION);
    }

    public static String replace(String text, String searchString, String replacement) {
        return replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
//        if (!isEmpty(text) && !isEmpty(searchString) && replacement != null && max != 0) {
        if (StringUtils.isNotEmpty(text)
                && StringUtils.isNotEmpty(searchString)
                && replacement != null
                && max != 0) {
            int start = 0;
            int end = text.indexOf(searchString, start);
            if (end == -1) {
                return text;
            } else {
                int replLength = searchString.length();
                int increase = replacement.length() - replLength;
                increase = increase < 0 ? 0 : increase;
                increase *= max < 0 ? 16 : (max > 64 ? 64 : max);

                StrBuilder buf;
                for(buf = new StrBuilder(text.length() + increase); end != -1; end = text.indexOf(searchString, start)) {
                    buf.append(text.substring(start, end)).append(replacement);
                    start = end + replLength;
                    --max;
                    if (max == 0) {
                        break;
                    }
                }

                buf.append(text.substring(start));
                return buf.toString();
            }
        } else {
            return text;
        }
    }
    /**
     * 把MySQL的服务名字中提取数据库，因为里面会有参数，如：walkersoft-share-marks?characterEncoding=UTF-8</p>
     * 提取之后结果为：walkersoft-share-marks
     * @param serviceName
     * @return
     */
    public static final String getMySQLSchemaName(String serviceName){
        if(StringUtils.isEmpty(serviceName)){
            return null;
        }
        int index = serviceName.indexOf("?");
        if(index >= 0){
            return serviceName.substring(0, index);
        } else {
            return serviceName;
        }
    }

}
