package com.walker.jdbc.generator.util;

import com.walker.jdbc.generator.Constants;
import com.walker.jdbc.generator.GenerateException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class GenPoUtils {

    private static final Logger logger = LoggerFactory.getLogger(GenPoUtils.class);

    public static final String PACKAGE_MODULE = "iplatform";

    public static List<String> getTemplates(String mbbs, boolean platformTable) {
        List<String> templates = new ArrayList<>();
//        if (mbbs.contains("po-old")) {
//            templates.add("potemplate/po.vm");
//        }
        if (mbbs.contains("to")) {
            templates.add("potemplate/vo.vm");
        }
        if (mbbs.contains("mapper")) {
            if(platformTable){
                templates.add("potemplate/mapper.vm");
            } else {
                templates.add("potemplate/mapper-camel.vm");
            }
        }
        if (mbbs.contains("po")) {
            if(platformTable){
                templates.add("potemplate/po-new.vm");
            } else {
                templates.add("potemplate/po-camel.vm");
            }
        }
        return templates;
    }

    public static void generatorCode(String mbbs
            , String table_name, String pk_name, String pk_type, List<Map<String, Object>> columns, ZipOutputStream zip) {
        Properties prop = new Properties();
        prop.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init(prop);

        // 是否平台表名称：'s_'开头的表？
        table_name = table_name.toLowerCase();
        boolean platformTable = table_name.startsWith(Constants.TABLE_PREFIX_PLATFORM);

        VelocityContext context = new VelocityContext();
        Configuration config = GenUtils.getConfig();
        context.put("columns", columns);
        context.put("table_name", table_name);
        context.put("pk_name", pk_name);
//        if(platformTable){
//        } else {
//            context.put("pk_name", StringUtils.transferUnderlineName2Camel(pk_name, false));
//        }
        context.put("pk_type", pk_type);
        context.put("stringUtils", new StringUtils());

        List<String> templates = getTemplates(mbbs, platformTable);
        try {
            for (String template : templates) {
                StringWriter sw = new StringWriter();
                Template tpl = Velocity.getTemplate(template, "UTF-8");
                tpl.merge(context, sw);

                zip.putNextEntry(new ZipEntry(getFileName(template, table_name)));
                IOUtils.write(sw.toString(), zip, "UTF-8");
                IOUtils.closeQuietly(sw);
            }
        } catch (IOException e) {
            throw new GenerateException("渲染模板失败，表名：" + table_name, e);
        }
    }

    public static String getFileName(String template, String table_name) {
        logger.debug("template = {},", template);
//        String table_name_u = GenUtils.toUpperFirst(table_name);
        String table_name_u = null;
        if(table_name.startsWith(Constants.TABLE_PREFIX_PLATFORM)){
            // 2023-03-23 平台表不转驼峰，仅首字母大写
            table_name_u = StringUtils.toUpperCaseFirst(table_name);
        } else {
            // 业务表，转为驼峰方式
            table_name_u = StringUtils.transferUnderlineName2Camel(table_name, true);
        }
        logger.debug("table_name_u = {}", table_name_u);

        String packagePath = "main" + File.separator + "java" + File.separator + "com" + File.separator + PACKAGE_MODULE + File.separator + "model";
        String[] ts = template.split("/");
//        String template_type = ts[0];
        String template_name = ts[1];
        if (template_name.equals("po.vm")) {
            return packagePath + File.separator + "po" + File.separator + table_name_u + ".java";
        }
        if (template_name.equals("po-new.vm") || template_name.equals("po-camel.vm")) {
//            return packagePath + File.separator + "newpo" + File.separator + table_name_u + ".java";
            return packagePath + File.separator + "po" + File.separator + table_name_u + ".java";
        }
        if (template_name.equals("vo.vm")) {
            return packagePath + File.separator + "to" + File.separator + table_name_u + "_t.java";
        }
        if (template_name.equals("mapper.vm") || template_name.equals("mapper-camel.vm")) {
            return packagePath + File.separator + "mapper" + File.separator + table_name_u + "_mapper.java";
        }
        return null;
    }
}
