package com.walker.jdbc.generator.util;

import com.walker.jdbc.generator.Constants;
import com.walker.jdbc.generator.GenerateException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class GenUtils {

    public static List<String> getTemplates(String mbbs){
        List<String> templates = new ArrayList<String>();
        if(Constants.vm_type_tree_list.equalsIgnoreCase(mbbs)){//树形列表
            //类
            templates.add("treelisttemplate/Controller.vm");
            templates.add("treelisttemplate/Service.vm");
            templates.add("treelisttemplate/ServiceImpl.vm");
            //页面
            templates.add("treelisttemplate/Index.vm");
            templates.add("treelisttemplate/Edit.vm");
            templates.add("treelisttemplate/Sort.vm");
            templates.add("treelisttemplate/Validate.vm");
        }else if(Constants.vm_type_list.equalsIgnoreCase(mbbs)){//单表增删查改
            //类
            templates.add("dbzscgtemplate/Controller.vm");
            templates.add("dbzscgtemplate/Service.vm");
            templates.add("dbzscgtemplate/ServiceImpl.vm");
            //页面
            templates.add("dbzscgtemplate/Index.vm");
            templates.add("dbzscgtemplate/Edit.vm");
            templates.add("dbzscgtemplate/Show.vm");
            templates.add("dbzscgtemplate/Sort.vm");
            templates.add("dbzscgtemplate/Validate.vm");
        }else if(Constants.vm_type_list_child.equalsIgnoreCase(mbbs)){//主子列表
            //类
            templates.add("paternitytemplate/Controller.vm");
            templates.add("paternitytemplate/Service.vm");
            templates.add("paternitytemplate/ServiceImpl.vm");
            //页面
            templates.add("paternitytemplate/Index.vm");
            templates.add("paternitytemplate/Edit.vm");
            templates.add("paternitytemplate/Show.vm");
            templates.add("paternitytemplate/Sort.vm");
            templates.add("paternitytemplate/Validate.vm");
            templates.add("paternitytemplate/ValidateAll.vm");
        }else if(Constants.vm_type_single_edit.equalsIgnoreCase(mbbs)){//单表动态行
            //类
            templates.add("dbdthtemplate/Controller.vm");
            templates.add("dbdthtemplate/Service.vm");
            templates.add("dbdthtemplate/ServiceImpl.vm");
            //页面
            templates.add("dbdthtemplate/Index.vm");
            templates.add("dbdthtemplate/Sort.vm");
            templates.add("dbdthtemplate/Validate.vm");
        }else if(Constants.vm_type_treeform.equalsIgnoreCase(mbbs)){//树+表单
            //类
            templates.add("treeformtemplate/Controller.vm");
            templates.add("treeformtemplate/Service.vm");
            templates.add("treeformtemplate/ServiceImpl.vm");
            //页面
            templates.add("treeformtemplate/Index.vm");
            templates.add("treeformtemplate/Edit.vm");
            templates.add("treeformtemplate/Show.vm");
            templates.add("treeformtemplate/Sort.vm");
            templates.add("treeformtemplate/Validate.vm");
        }else if(Constants.vm_type_publicpage.equalsIgnoreCase(mbbs)){//公共多选页面
            //类
            templates.add("publicpagetemplate/Controller.vm");
            templates.add("publicpagetemplate/Service.vm");
            templates.add("publicpagetemplate/ServiceImpl.vm");
            //页面
            templates.add("publicpagetemplate/Index.vm");
        }else if(Constants.vm_type_anzscg.equalsIgnoreCase(mbbs)){//按钮增删查改
            //类
            templates.add("anzscgtemplate/Controller.vm");
            templates.add("anzscgtemplate/Service.vm");
            templates.add("anzscgtemplate/ServiceImpl.vm");
            //页面
            templates.add("anzscgtemplate/Index.vm");
            templates.add("anzscgtemplate/Edit.vm");
            templates.add("anzscgtemplate/Validate.vm");
        }else if(Constants.vm_type_slbjck.equalsIgnoreCase(mbbs)){//双列编辑查看
            //类
            templates.add("slbjcktemplate/Controller.vm");
            templates.add("slbjcktemplate/Service.vm");
            templates.add("slbjcktemplate/ServiceImpl.vm");
            //页面
            templates.add("slbjcktemplate/Index.vm");
            templates.add("slbjcktemplate/Edit.vm");
            templates.add("slbjcktemplate/Show.vm");
            templates.add("slbjcktemplate/Validate.vm");
        }
        return templates;
    }

    /**
     * 获取基础路径包名称
     * @param tableEntity
     * @param split
     * @return
     */
    public static String getBaseName(Map<String, String> tableEntity,String split) {
        String packagePath="";
        if(StringUtils.isNotEmpty(tableEntity.get("module_name"))){
            packagePath += tableEntity.get("module_name");
        }
        if(StringUtils.isNotEmpty(tableEntity.get("sub_module_name"))){
            packagePath += split +tableEntity.get("sub_module_name");
        }
        if(StringUtils.isNotEmpty(tableEntity.get("function_name"))){
            packagePath += split +tableEntity.get("function_name");
        }
        return packagePath;
    }
    public static String getBaseZxtName(Map<String, String> tableEntity,String split) {
        String packagePath="";
        if(StringUtils.isNotEmpty(tableEntity.get("zxtbs"))){
            packagePath += tableEntity.get("zxtbs");
        }
        if(StringUtils.isNotEmpty(tableEntity.get("module_name"))){
            packagePath += split + tableEntity.get("module_name");
        }
        if(StringUtils.isNotEmpty(tableEntity.get("sub_module_name"))){
            packagePath += split +tableEntity.get("sub_module_name");
        }
        if(StringUtils.isNotEmpty(tableEntity.get("function_name"))){
            packagePath += split +tableEntity.get("function_name");
        }
        return packagePath;
    }
    /**
     * 获取文件名
     */
    public static String getFileName(String template,Map<String, Object> tableEntity) {
        String className=tableEntity.get("class_name").toString();
        //String codeName=tableEntity.get("code_name");
        String className_u=GenUtils.toUpperFirst(className);
        //基础存放路径
        String htmlPath="main" + File.separator + "resources" + File.separator + "views";
        String packagePath = "main" + File.separator + "java";
        String jsPath="main" + File.separator + "resources" + File.separator + "static"+ File.separator + "js";
        if (StringUtils.isNotEmpty(tableEntity.get("package_name").toString())) {
            packagePath += File.separator + tableEntity.get("package_name").toString().replace(".", File.separator);
        }
        if(StringUtils.isNotEmpty(tableEntity.get("zxtbs").toString())){
            packagePath += File.separator +tableEntity.get("zxtbs")+File.separator+"model";
            htmlPath += File.separator +tableEntity.get("zxtbs");
            jsPath += File.separator +tableEntity.get("zxtbs");
        }
        if(StringUtils.isNotEmpty(tableEntity.get("module_name").toString())){
            packagePath += File.separator +tableEntity.get("module_name");
            htmlPath += File.separator +tableEntity.get("module_name");
            jsPath += File.separator +tableEntity.get("module_name");
        }
        if(StringUtils.isNotEmpty(tableEntity.get("sub_module_name").toString())){
            packagePath += File.separator +tableEntity.get("sub_module_name");
            htmlPath += File.separator +tableEntity.get("sub_module_name");
            jsPath += File.separator +tableEntity.get("sub_module_name");
        }
        if(StringUtils.isNotEmpty(tableEntity.get("function_name").toString())){
            packagePath += File.separator +tableEntity.get("function_name");
            htmlPath += File.separator +tableEntity.get("function_name");
            jsPath += File.separator +tableEntity.get("function_name");
        }
        String [] ts=template.split("/");
        String template_type=ts[0];
        String template_name=ts[1];
        //树
        if(Constants.vm_type_tree_list.equalsIgnoreCase(template_type)){
            if (template_name.equals("Controller.vm" )) {
                return packagePath + File.separator + className_u + "Controller.java";
            }
            if (template_name.equals("Service.vm" )) {
                return packagePath + File.separator + className_u + "Service.java";
            }
            if (template_name.equals("ServiceImpl.vm" )) {
                return packagePath + File.separator + className_u + "ServiceImpl.java";
            }
            if (template_name.equals("Index.vm" )) {
                return htmlPath+ File.separator + className+ "index.ftl";
            }
            if (template_name.equals("Edit.vm" )) {
                return htmlPath+ File.separator + className + "edit.ftl";
            }
            if (template_name.equals("Sort.vm" )) {
                return htmlPath+ File.separator + className + "sort.ftl";
            }
            if (template_name.equals("Validate.vm" )) {
                return jsPath + File.separator + className + "validate.js";
            }
        }else if(Constants.vm_type_list.equalsIgnoreCase(template_type)){//单表增删查改
            if (template_name.equals("Controller.vm" )) {
                return packagePath + File.separator + className_u + "Controller.java";
            }
            if (template_name.equals("Service.vm" )) {
                return packagePath + File.separator + className_u + "Service.java";
            }
            if (template_name.equals("ServiceImpl.vm" )) {
                return packagePath + File.separator + className_u + "ServiceImpl.java";
            }
            if (template_name.equals("Index.vm" )) {
                return htmlPath+ File.separator + className+ "index.ftl";
            }
            if (template_name.equals("Edit.vm" )) {
                return htmlPath+ File.separator + className + "edit.ftl";
            }
            if (template_name.equals("Sort.vm" )) {
                return htmlPath+ File.separator + className + "sort.ftl";
            }
            if (template_name.equals("Show.vm" )) {
                return htmlPath+ File.separator + className + "show.ftl";
            }
            if (template_name.equals("Validate.vm" )) {
                return jsPath + File.separator + className + "validate.js";
            }
        }else if(Constants.vm_type_list_child.equalsIgnoreCase(template_type)){//主子表
            if (template_name.equals("Controller.vm" )) {
                return packagePath + File.separator + className_u + "Controller.java";
            }
            if (template_name.equals("Service.vm" )) {
                return packagePath + File.separator + className_u + "Service.java";
            }
            if (template_name.equals("ServiceImpl.vm" )) {
                return packagePath + File.separator + className_u + "ServiceImpl.java";
            }
            if (template_name.equals("Index.vm" )) {
                return htmlPath+ File.separator + className+ "index.ftl";
            }
            if (template_name.equals("Edit.vm" )) {
                return htmlPath+ File.separator + className + "edit.ftl";
            }
            if (template_name.equals("Sort.vm" )) {
                return htmlPath+ File.separator + className + "sort.ftl";
            }
            if (template_name.equals("Show.vm" )) {
                return htmlPath+ File.separator + className + "show.ftl";
            }
            if (template_name.equals("Validate.vm" )) {
                return jsPath + File.separator + className + "validate.js";
            }
            if (template_name.equals("ValidateAll.vm" )) {
                return jsPath + File.separator + className + "validateAll.js";
            }
        }else if(Constants.vm_type_single_edit.equalsIgnoreCase(template_type)){//单表动态行
            if (template_name.equals("Controller.vm" )) {
                return packagePath + File.separator + className_u + "Controller.java";
            }
            if (template_name.equals("Service.vm" )) {
                return packagePath + File.separator + className_u + "Service.java";
            }
            if (template_name.equals("ServiceImpl.vm" )) {
                return packagePath + File.separator + className_u + "ServiceImpl.java";
            }
            if (template_name.equals("Index.vm" )) {
                return htmlPath+ File.separator + className+ "index.ftl";
            }
            if (template_name.equals("Validate.vm" )) {
                return jsPath + File.separator + className + "validate.js";
            }
            if (template_name.equals("Sort.vm" )) {
                return htmlPath+ File.separator + className + "sort.ftl";
            }
        }else if(Constants.vm_type_treeform.equalsIgnoreCase(template_type)){//树+表单
            if (template_name.equals("Controller.vm" )) {
                return packagePath + File.separator + className_u + "Controller.java";
            }
            if (template_name.equals("Service.vm" )) {
                return packagePath + File.separator + className_u + "Service.java";
            }
            if (template_name.equals("ServiceImpl.vm" )) {
                return packagePath + File.separator + className_u + "ServiceImpl.java";
            }
            if (template_name.equals("Index.vm" )) {
                return htmlPath+ File.separator + className+ "index.ftl";
            }
            if (template_name.equals("Edit.vm" )) {
                return htmlPath+ File.separator + className + "edit.ftl";
            }
            if (template_name.equals("Sort.vm" )) {
                return htmlPath+ File.separator + className + "sort.ftl";
            }
            if (template_name.equals("Show.vm" )) {
                return htmlPath+ File.separator + className + "show.ftl";
            }
            if (template_name.equals("Validate.vm" )) {
                return jsPath + File.separator + className + "validate.js";
            }
        }else if(Constants.vm_type_publicpage.equalsIgnoreCase(template_type)){//公共多选页面
            if (template_name.equals("Controller.vm" )) {
                return packagePath + File.separator + className_u + "Controller.java";
            }
            if (template_name.equals("Service.vm" )) {
                return packagePath + File.separator + className_u + "Service.java";
            }
            if (template_name.equals("ServiceImpl.vm" )) {
                return packagePath + File.separator + className_u + "ServiceImpl.java";
            }
            if (template_name.equals("Index.vm" )) {
                return htmlPath+ File.separator + className+ "index.ftl";
            }
        }else if(Constants.vm_type_anzscg.equalsIgnoreCase(template_type)){//按钮增删查改
            if (template_name.equals("Controller.vm" )) {
                return packagePath + File.separator + className_u + "Controller.java";
            }
            if (template_name.equals("Service.vm" )) {
                return packagePath + File.separator + className_u + "Service.java";
            }
            if (template_name.equals("ServiceImpl.vm" )) {
                return packagePath + File.separator + className_u + "ServiceImpl.java";
            }
            if (template_name.equals("Index.vm" )) {
                return htmlPath+ File.separator + className+ "index.ftl";
            }
            if (template_name.equals("Edit.vm" )) {
                return htmlPath+ File.separator + className + "edit.ftl";
            }
            if (template_name.equals("Validate.vm" )) {
                return jsPath + File.separator + className + "validate.js";
            }
        }else if(Constants.vm_type_slbjck.equalsIgnoreCase(template_type)){//双列编辑查看
            if (template_name.equals("Controller.vm" )) {
                return packagePath + File.separator + className_u + "Controller.java";
            }
            if (template_name.equals("Service.vm" )) {
                return packagePath + File.separator + className_u + "Service.java";
            }
            if (template_name.equals("ServiceImpl.vm" )) {
                return packagePath + File.separator + className_u + "ServiceImpl.java";
            }
            if (template_name.equals("Index.vm" )) {
                return htmlPath+ File.separator + className+ "index.ftl";
            }
            if (template_name.equals("Edit.vm" )) {
                return htmlPath+ File.separator + className + "edit.ftl";
            }
            if (template_name.equals("Show.vm" )) {
                return htmlPath+ File.separator + className + "show.ftl";
            }
            if (template_name.equals("Validate.vm" )) {
                return jsPath + File.separator + className + "validate.js";
            }
        }
        return null;
    }

    /**
     * 生成代码
     */
    public static void generatorCode(Map<String, Object> tableEntity,
                                     List<Map<String, Object>> columns, ZipOutputStream zip) {
        //设置velocity资源加载器
        Properties prop = new Properties();
        prop.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init(prop);
        //配置信息
        //封装模板数据
        tableEntity.put("datetime", DateUtils.format(new Date(), DateUtils.DATE_TIME_PATTERN));
        VelocityContext context = new VelocityContext(tableEntity);
        List<Map<String, Object>> columns_r = new ArrayList<>();

        List<Map<String, Object>> columns_map = new ArrayList<>();
        List<Map<String, Object>> columns_cmap = new ArrayList<>();
        List<Map<String, Object>> columns_sql = new ArrayList<>();
        List<Map<String, Object>> columns_file = new ArrayList<>();
        List<Map<String, Object>> columns_auto = new ArrayList<>();
        List<Map<String, Object>> tableList = new ArrayList<>();//关联子表信息
        Configuration config = GenUtils.getConfig();

        String mb = tableEntity.get("tpl_category").toString();
        //if (mb.equals(Constants.vm_type_tree_list) || mb.equals(Constants.vm_type_treeform) || mb.equals(Constants.vm_type_publicpage)) {
        String first_width = null;
        String last_width = null;
        String first_column_code = null;
        String sfgdcx = null;
        String firstCount = null;
        String secondCount = null;
        if (columns.size() > 0) {
            first_width = columns.get(columns.size() - 3).get("first_width")==null?"":columns.get(columns.size() - 3).get("first_width").toString();
            last_width = columns.get(columns.size() - 3).get("last_width")==null?"":columns.get(columns.size() - 3).get("last_width").toString();
            first_column_code = columns.get(columns.size() - 3).get("first_column_code")==null?"":columns.get(columns.size() - 3).get("first_column_code").toString();
            sfgdcx = columns.get(columns.size() - 2).get("sfgdcx")==null?"":columns.get(columns.size() - 2).get("sfgdcx").toString();
            firstCount = columns.get(columns.size() - 1).get("firstCount")==null?"":columns.get(columns.size() - 1).get("firstCount").toString();
            secondCount = columns.get(columns.size() - 1).get("secondCount")==null?"":columns.get(columns.size() - 1).get("secondCount").toString();
        }
        context.put("first_width", first_width);
        context.put("last_width", last_width);
        context.put("first_column_code", first_column_code);
        context.put("sfgdcx", sfgdcx);
        context.put("firstCount", Integer.valueOf(StringUtils.isEmpty(firstCount)?"0":firstCount));
        context.put("secondCount", Integer.valueOf(StringUtils.isEmpty(secondCount)?"0":secondCount));
        //}

        if(tableEntity.get("child_table") != null && tableEntity.get("child_table") != "" && tableEntity.get("child_column") != null && tableEntity.get("child_column") != ""){
            String[] tablesinfo = tableEntity.get("child_table").toString().split(",");
            String[] columnsinfo = tableEntity.get("child_column").toString().split(",");
            if (tablesinfo != null && tablesinfo.length > 0 && columnsinfo != null && columnsinfo.length > 0) {
                for (int i=0;i<tablesinfo.length;i++) {
                    for (int j=0;j<columnsinfo.length;j++) {
                        if(i==j){
                            Map<String, Object> table_map = new HashMap<String, Object>();
                            table_map.put("table_code", tablesinfo[i].toLowerCase());
                            table_map.put("table_code_u", GenUtils.toUpperFirst(tablesinfo[i].toLowerCase()));
                            table_map.put("table_column", columnsinfo[j]);
                            table_map.put("table_column_u", GenUtils.toUpperFirst(columnsinfo[j]));
                            tableList.add(table_map);
                        }
                    }
                }
            }
        }

        //for (List<Map<String, Object>> columns : columnlist) {
        for (Map<String, Object> tmap : columns) {
            if (tmap.get("column_code") != null && tmap.get("column_code") != "") {
                tmap.put("column_code_u", GenUtils.toUpperFirst(tmap.get("column_code").toString()));
            }
            tmap.put("list_type", "cmap");
            if (tmap.get("list_data") != null) {
                String listdata = tmap.get("list_data").toString();
				/*String[] t = listdata.split("5");
				if (t.length > 1) {
					tmap.put("listdataval", t[1]);
				}*/
                if (listdata.startsWith("map=")) {
                    tmap.put("listdataval", listdata.substring(4));
                    tmap.put("list_type", "map");
                    //组织常量类get方法
                    String map = listdata.substring(4).split("\\.")[listdata.substring(4).split("\\.").length-1];
                    String lurl = listdata.substring(4).replace(map,"");
                    String getMethod = lurl+"get"+map;
                    tmap.put("getmethod", getMethod);
                    if(tmap.get("column_type").equals("NVARCHAR2")||tmap.get("column_type").equals("varchar")){
                        tmap.put("convertlx", "Str");
                    }else if(tmap.get("column_type").equals("NUMBER")||tmap.get("column_type").equals("decimal")){
                        tmap.put("convertlx", "Int");
                    }
                    columns_map.add(tmap);
                } else if (listdata.startsWith("cmap=")) {
                    tmap.put("listdataval", listdata.substring(5));
                    tmap.put("list_type", "cmap");
                    //组织常量类get方法
                    String map = listdata.substring(5).split("\\.")[listdata.substring(5).split("\\.").length-1];
                    String lurl = listdata.substring(5).replace(map,"");
                    String getMethod = lurl+"get"+map;
                    tmap.put("getmethod", getMethod);
                    if(tmap.get("column_type").equals("NVARCHAR2")||tmap.get("column_type").equals("varchar")){
                        tmap.put("convertlx", "Str");
                    }else if(tmap.get("column_type").equals("NUMBER")||tmap.get("column_type").equals("decimal")){
                        tmap.put("convertlx", "Int");
                    }
                    columns_cmap.add(tmap);
                } else if (listdata.startsWith("sql=")) {
                    tmap.put("listdataval", listdata.substring(4));
                    tmap.put("list_type", "sql");
                    //组织常量类get方法
                    String map = listdata.substring(4).split("\\.")[listdata.substring(4).split("\\.").length-1];
                    String lurl = listdata.substring(4).replace(map,"");
                    String getMethod = lurl+"get"+map;
                    tmap.put("getmethod", getMethod);
                    if(tmap.get("column_type").equals("NVARCHAR2")||tmap.get("column_type").equals("varchar")){
                        tmap.put("convertlx", "Str");
                    }else if(tmap.get("column_type").equals("NUMBER")||tmap.get("column_type").equals("decimal")){
                        tmap.put("convertlx", "Int");
                    }
                    columns_sql.add(tmap);
                } else if (listdata.startsWith("max_file_size=")) {
                    tmap.put("list_type", "file");
                    columns_file.add(tmap);
                }
            }
            if (tmap.get("insert_type") != null) {
                String insert_type = tmap.get("insert_type").toString();
                if (insert_type.equals("insert_type_sxh")) {
                    tmap.put("insert_type", "insert_type_sxh");
                } else {
                    tmap.put("insert_type", config.getString(insert_type + "_val"));
                }
                columns_auto.add(tmap);
            }
            columns_r.add(tmap);
            //判断是否有人员或机构
            if (tmap.get("show_type") != null && (tmap.get("show_type").equals("show_type_ry") || tmap.get("show_type").equals("show_type_jg"))) {
                context.put("isryjg", true);
            }
        }
        //}
        context.put("columns",columns_r);
        context.put("columns_auto",columns_auto);
        context.put("columns_map",columns_map);
        context.put("columns_cmap",columns_cmap);
        context.put("columns_sql",columns_sql);
        context.put("columns_file",columns_file);
        context.put("tableList",tableList);

        //获取模板列表
        List<String> templates = getTemplates(tableEntity.get("tpl_category").toString());
        try {
            for(String template : templates){
                //渲染模板
                StringWriter sw = new StringWriter();
                Template tpl = Velocity.getTemplate(template, "UTF-8");
                tpl.merge(context, sw);
                //添加到zip
                zip.putNextEntry(new ZipEntry(getFileName(template,tableEntity)));
                IOUtils.write(sw.toString(), zip, "UTF-8");
                IOUtils.closeQuietly(sw);
            }
        } catch (IOException e) {
            throw new GenerateException("渲染模板失败，表名：" + tableEntity.get("table_name"), e);
        }

    }

    /**
     * 列名转换成Java属性名
     */
    public static String columnToJava(String columnName) {
        return WordUtils.capitalizeFully(columnName, new char[]{'_'}).replace("_", "");
    }

    /**
     * 表名转换成Java类名
     */
    public static String tableToJava(String tableName, String tablePrefix) {
        if(StringUtils.isNotEmpty(tablePrefix)){
            String className = tableName.split(tablePrefix)[1];
            return columnToJava(className);
        }else{
            return columnToJava(tableName);
        }
    }

    /**
     * 获取配置信息
     */
    public static Configuration getConfig(){
        try {
            return new PropertiesConfiguration("generator.properties");
        } catch (ConfigurationException e) {
            throw new GenerateException("获取配置文件失败:generator.properties", e);
        }
    }

    //首字母转大写
    public static String toUpperFirst(String s){
        if(Character.isUpperCase(s.charAt(0)))
            return s;
        else
            return (new StringBuilder()).append(Character.toUpperCase(s.charAt(0))).append(s.substring(1)).toString();
    }

    //转换map 统一新增首字母大写内容
    public static Map<String,String> tranMap(Map<String,Object> tmap){
        Map<String,String> rmap=new HashMap<>();
        for (Map.Entry<String, Object> entry : tmap.entrySet()) {
            if(entry.getValue()==null){
                rmap.put(entry.getKey(),"");
                rmap.put(entry.getKey()+"_u","");
            }else{
                rmap.put(entry.getKey(),entry.getValue().toString().toLowerCase());
                rmap.put(entry.getKey()+"_u",GenUtils.toUpperFirst(entry.getValue().toString().toLowerCase()));
            }
        }
        return rmap;
    }

    public static LinkedHashMap<String,String> configToMap(String config_type) {
        //配置信息
        Configuration prop = GenUtils.getConfig();
        List<Object> keys=prop.getList(config_type);
        LinkedHashMap<String,String> resultMap=new LinkedHashMap<>();
        for(Object key:keys){
            resultMap.put(key.toString(),prop.getString(key.toString()));
        }
        return resultMap;
    }
}
