/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.generator.util;

public class StringUtils {
    private static final String TEXT_UNDERLINE = "_";
    private static final char CHAR_UNDERLINE = '_';
    private static final String TEXT_EMPTY = "";

    public static final String transferUnderlineName2Camel(String underlineName, boolean upperFirstChar) {
        if (underlineName == null || underlineName.equals(TEXT_EMPTY)) {
            throw new IllegalArgumentException("underlineName\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        int index = underlineName.indexOf(TEXT_UNDERLINE);
        if (index == 0) {
            return underlineName;
        }
        if (index < 0) {
            if (upperFirstChar) {
                return StringUtils.toUpperCaseFirst(underlineName);
            }
            return underlineName;
        }
        StringBuilder text = new StringBuilder();
        int count = underlineName.length();
        char c = '\u0000';
        int startUpperCase = 0;
        for (int i = 0; i < count; ++i) {
            c = underlineName.charAt(i);
            if (startUpperCase == 0) {
                if (i == 0) {
                    if (upperFirstChar) {
                        text.append(String.valueOf(c).toUpperCase());
                    } else {
                        text.append(c);
                    }
                } else {
                    text.append(String.valueOf(c).toUpperCase());
                }
                ++startUpperCase;
                continue;
            }
            if (c == '_') {
                startUpperCase = 0;
                continue;
            }
            text.append(c);
        }
        return text.toString();
    }

    public static int intValue(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return Integer.parseInt(obj.toString());
    }

    public static boolean isEmpty(String str) {
        return str == null || TEXT_EMPTY.equals(str);
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String join(String[] src, String separator, String quot) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < src.length; ++i) {
            if (i > 0 && separator != null) {
                sb.append(separator);
            }
            if (quot != null) {
                sb.append(quot);
            }
            sb.append(src[i]);
            if (quot == null) continue;
            sb.append(quot);
        }
        return sb.toString();
    }

    public static String safeToString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static String les(Object obj, int len) {
        if (obj == null || obj.toString() == null) {
            return null;
        }
        if (obj.toString().length() > len) {
            return obj.toString().substring(0, len);
        }
        return obj.toString();
    }

    public static String toLowerCaseFirst(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        chs[0] = Character.toLowerCase(chs[0]);
        return String.valueOf(chs);
    }

    public static String toUpperCaseFirst(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        chs[0] = Character.toUpperCase(chs[0]);
        return String.valueOf(chs);
    }

    public static String getJavaType(String strTemp) {
        String strJavaType = TEXT_EMPTY;
        strTemp = strTemp.toLowerCase();
        System.out.print(strTemp);
        if (strTemp.indexOf("bigint") >= 0) {
            strJavaType = "Long";
        } else if (strTemp.indexOf("int") >= 0 || strTemp.indexOf("tinyint") >= 0) {
            strJavaType = "Integer";
        } else if (strTemp.indexOf("longtext") >= 0) {
            strJavaType = "String";
        } else if (strTemp.indexOf("varchar") >= 0) {
            strJavaType = "String";
        } else if (strTemp.indexOf("long") >= 0) {
            strJavaType = "Long";
        } else if (strTemp.indexOf("float") >= 0) {
            strJavaType = "Float";
        } else if (strTemp.indexOf("double") >= 0) {
            strJavaType = "Double";
        } else if (strTemp.indexOf("boolean") >= 0 || strTemp.indexOf("bit") >= 0) {
            strJavaType = "Boolean";
        } else if (strTemp.indexOf("string") >= 0) {
            strJavaType = "String";
        } else if (strTemp.indexOf("date") >= 0) {
            strJavaType = "java.util.Date";
        } else if (strTemp.indexOf("clob") >= 0) {
            strJavaType = "String";
        } else if (strTemp.indexOf("text") >= 0) {
            strJavaType = "String";
        } else if (strTemp.indexOf("blob") >= 0) {
            strJavaType = "String";
        } else if (strTemp.indexOf("char") >= 0) {
            strJavaType = "String";
        } else if (strTemp.indexOf("number") >= 0) {
            strJavaType = "Integer";
        } else if (strTemp.indexOf("materialized_clob") >= 0) {
            strJavaType = "String";
        } else if (strTemp.indexOf("materialized_blob") >= 0) {
            strJavaType = "byte[]";
        } else if (strTemp.indexOf("big_decimal") >= 0 || strTemp.indexOf("decimal") >= 0) {
            strJavaType = "java.math.BigDecimal";
        } else if (strTemp.indexOf("numeric") >= 0) {
            strJavaType = "Double";
        } else {
            throw new RuntimeException(strTemp + "\u6ca1\u6709\u5bf9\u5e94\u7684java\u7c7b\u578b\uff01");
        }
        return strJavaType;
    }

    public static void main(String[] args) {
        String input = "etaa_question_";
        String result = StringUtils.transferUnderlineName2Camel(input, false);
        System.out.println(result);
    }
}

