package com.walker.jdbc.generator;

import java.util.LinkedHashMap;
import java.util.Map;

public class Constants {

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 系统定义的常量，2023-03-23
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /** 平台表名前缀，平台表名不需要转成驼峰，还按照老的下划线格式，仅首字母大写。 */
    public static final String TABLE_PREFIX_PLATFORM = "s_";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~ End ~~~~~~~~~~~~~~~~~~~~~~

    public static final int SF_F = 0;
    public static final int SF_S = 1;
    public static Map<Integer, String> GG_COLUMN_SF_Map = new LinkedHashMap();
    public static final String equalItem = "=";
    public static final String likeItem = "%";
    public static final String greaterItem = ">";
    public static final String lessItem = "<";
    public static final String unequalItem = "!=";
    public static Map<String, String> GG_COLUMN_QUERY_TYPE_Map;
    public static final String TEXT = "text";
    public static final String TEXTAREA = "textarea";
    public static final String HIDDEN = "hidden";
    public static final String SELECT = "select";
    public static final String SELECT_MORE = "selectmore";
    public static final String RADIO = "radio";
    public static final String CHECKBOX = "checkbox";
    public static final String DATE = "date";
    public static final String DATE_TIME = "datetime";
    public static final String SELECT_RY = "ry";
    public static final String SELECT_JG = "jg";
    public static final String SELECT_AREA = "area";
    public static Map<String, String> GG_COLUMN_SHOW_TYPE_Map;
    public static final String attr_type_String = "String";
    public static final String attr_type_Number = "Number";
    public static Map<String, String> attr_type_Map;
    public static final String vm_type_tree_list = "treelisttemplate";
    public static final String vm_type_list = "dbzscgtemplate";
    public static final String vm_type_list_child = "paternitytemplate";
    public static final String vm_type_single_edit = "dbdthtemplate";
    public static final String vm_type_treeform = "treeformtemplate";
    public static final String vm_type_publicpage = "publicpagetemplate";
    public static final String vm_type_anzscg = "anzscgtemplate";
    public static final String vm_type_slbjck = "slbjcktemplate";
    public static Map<String, String> VM_TYPE_StringMap;
    public static final String cjr = "cjr";
    public static final String cjrmc = "cjrmc";
    public static final String cjsj = "cjsj";
    public static Map<String, String> insert_typeMap;
    public static final String list_width_shw = "35";
    public static final String list_width_lhw = "65";
    public static Map<String, String> list_widthMap;
    public static final String options_email = "email";
    public static final String options_url = "url";
    public static final String options_date = "date";
    public static final String options_datetime = "datetime";
    public static final String options_number = "number";
    public static final String options_string = "string";
    public static final String options_phone = "phone";
    public static final String options_card = "card";
    public static Map<String, String> options_Map;
    public static final String vm_type_po = "po-old";
    public static final String vm_type_po_new = "po-new";
    public static final String vm_type_to = "to";
    public static final String vm_type_mapper = "mapper";
    public static Map<String, String> VM_TYPE_POMap;
    public static final Integer GG_STUDENT_SEX_BOY;
    public static final Integer GG_STUDENT_SEX_GIRL;
    public static final Map<Integer, String> GG_STUDENT_SEX_MAP;
    public static final String GG_STUDENT_HOBBY_LQ = "basketball";
    public static final String GG_STUDENT_HOBBY_CP = "run";
    public static final String GG_STUDENT_HOBBY_TYY = "music";
    public static final String GG_STUDENT_HOBBY_KS = "book";
    public static final String GG_STUDENT_HOBBY_PBQ = "pinp";
    public static final String GG_STUDENT_HOBBY_YMQ = "yumaoq";
    public static final String GG_STUDENT_HOBBY_TS = "tiaos";
    public static final Map<String, String> GG_STUDENT_HOBBY_MAP;
    public static final String GG_STUDENT_SUBJECT_YW = "yuwen";
    public static final String GG_STUDENT_SUBJECT_SX = "shuxue";
    public static final String GG_STUDENT_SUBJECT_YY = "yingyu";
    public static final Map<String, String> GG_STUDENT_SUBJECT_MAP;
    public static final int GG_ZDLX_ZDZLX_NUMBER = 1;
    public static final int GG_ZDLX_ZDZLX_CHAR = 3;
    public static final int GG_ZDLX_ZDZLX_IMAGE = 12;
    public static final int GG_ZDLX_ZDZLX_FILE = 15;
    public static final Map<Integer, String> KJGL_WLJK_MAP;
    public static final int GG_DBZSCG_LB_YBLXR = 1;
    public static final int GG_DBZSCG_LB_FZR = 2;
    public static final int GG_DBZSCG_LB_ZYRY = 3;
    public static final Map<Integer, String> GG_DBZSCG_LB_MAP;
    public static final Integer GG_DBZSCG_XMLX_HW;
    public static final Integer GG_DBZSCG_XMLX_GC;
    public static final Integer GG_DBZSCG_XMLX_FW;
    public static final Map<Integer, String> GG_DBZSCG_XMLX_MAP;

    public static String getinsert_typeMap(String lx)
    {
        return (String)insert_typeMap.get(lx);
    }

    public static String getGG_STUDENT_SEX_MAP(Integer lx)
    {
        return (String)GG_STUDENT_SEX_MAP.get(lx);
    }

    public static String getGG_STUDENT_HOBBY_MAP(String bblx)
    {
        return (String)GG_STUDENT_HOBBY_MAP.get(bblx);
    }

    public static String getGG_STUDENT_SUBJECT_MAP(String bblx)
    {
        return (String)GG_STUDENT_SUBJECT_MAP.get(bblx);
    }

    public static String getKJGL_WLJK_MAP_Label(Integer zdzlx)
    {
        return (String)KJGL_WLJK_MAP.get(zdzlx);
    }

    public static String getGG_DBZSCG_LB_MAP_Label(Integer lb)
    {
        return (String)GG_DBZSCG_LB_MAP.get(lb);
    }

    public static String getGG_DBZSCG_XMLX_MAP_Label(Integer lb)
    {
        return (String)GG_DBZSCG_XMLX_MAP.get(lb);
    }

    static
    {
        GG_COLUMN_SF_Map.put(Integer.valueOf(0), "否");
        GG_COLUMN_SF_Map.put(Integer.valueOf(1), "是");

        GG_COLUMN_QUERY_TYPE_Map = new LinkedHashMap();

        GG_COLUMN_QUERY_TYPE_Map.put("=", "=");
        GG_COLUMN_QUERY_TYPE_Map.put("%", "%");
        GG_COLUMN_QUERY_TYPE_Map.put(">", ">");
        GG_COLUMN_QUERY_TYPE_Map.put("<", "<");
        GG_COLUMN_QUERY_TYPE_Map.put("!=", "!=");

        GG_COLUMN_SHOW_TYPE_Map = new LinkedHashMap();

        GG_COLUMN_SHOW_TYPE_Map.put("text", "单行文本框");
        GG_COLUMN_SHOW_TYPE_Map.put("textarea", "多行文本框");
        GG_COLUMN_SHOW_TYPE_Map.put("hidden", "隐藏域字段");
        GG_COLUMN_SHOW_TYPE_Map.put("select", "单选下拉框");
        GG_COLUMN_SHOW_TYPE_Map.put("selectmore", "多选下拉框");
        GG_COLUMN_SHOW_TYPE_Map.put("radio", "单选按钮");
        GG_COLUMN_SHOW_TYPE_Map.put("checkbox", "复选框");
        GG_COLUMN_SHOW_TYPE_Map.put("date", "日期选择");
        GG_COLUMN_SHOW_TYPE_Map.put("datetime", "日期时间");
        GG_COLUMN_SHOW_TYPE_Map.put("ry", "人员选择");
        GG_COLUMN_SHOW_TYPE_Map.put("jg", "机构选择");
        GG_COLUMN_SHOW_TYPE_Map.put("area", "区域选择");

        attr_type_Map = new LinkedHashMap();

        attr_type_Map.put("String", "String");
        attr_type_Map.put("Number", "Number");

        VM_TYPE_StringMap = new LinkedHashMap();

        VM_TYPE_StringMap.put("treelisttemplate", "树形表单增删查改");
        VM_TYPE_StringMap.put("dbzscgtemplate", "单表增删查改");
        VM_TYPE_StringMap.put("paternitytemplate", "主子表增删查改(动态行)");
        VM_TYPE_StringMap.put("dbdthtemplate", "单表动态行");
        VM_TYPE_StringMap.put("treeformtemplate", "树+表单");
        VM_TYPE_StringMap.put("publicpagetemplate", "公共多选页面");
        VM_TYPE_StringMap.put("anzscgtemplate", "按钮增删查改");
        VM_TYPE_StringMap.put("slbjcktemplate", "双列编辑查看");

        insert_typeMap = new LinkedHashMap();

        insert_typeMap.put("cjr", "创建人");
        insert_typeMap.put("cjrmc", "创建人名称");
        insert_typeMap.put("cjsj", "创建时间");

        list_widthMap = new LinkedHashMap();

        list_widthMap.put("35", "35");
        list_widthMap.put("65", "65");

        options_Map = new LinkedHashMap();

        options_Map.put("email", "邮箱");
        options_Map.put("url", "网址");
        options_Map.put("date", "日期");
        options_Map.put("datetime", "时间");
        options_Map.put("number", "数值");
        options_Map.put("string", "字符串");
        options_Map.put("phone", "电话或手机");
        options_Map.put("card", "身份证号");

        VM_TYPE_POMap = new LinkedHashMap();

        VM_TYPE_POMap.put("po-old", "PO模板");
        VM_TYPE_POMap.put("po-new", "新版PO模板");
        VM_TYPE_POMap.put("to", "TO模板");
        VM_TYPE_POMap.put("mapper", "mapper模板");

        GG_STUDENT_SEX_BOY = Integer.valueOf(1);
        GG_STUDENT_SEX_GIRL = Integer.valueOf(2);
        GG_STUDENT_SEX_MAP = new LinkedHashMap();

        GG_STUDENT_SEX_MAP.put(GG_STUDENT_SEX_BOY, "男");
        GG_STUDENT_SEX_MAP.put(GG_STUDENT_SEX_GIRL, "女");

        GG_STUDENT_HOBBY_MAP = new LinkedHashMap();

        GG_STUDENT_HOBBY_MAP.put("basketball", "篮球");
        GG_STUDENT_HOBBY_MAP.put("run", "长跑");
        GG_STUDENT_HOBBY_MAP.put("music", "听音乐");
        GG_STUDENT_HOBBY_MAP.put("book", "看书");
        GG_STUDENT_HOBBY_MAP.put("pinp", "乒乓球");
        GG_STUDENT_HOBBY_MAP.put("yumaoq", "羽毛球");
        GG_STUDENT_HOBBY_MAP.put("tiaos", "跳绳");

        GG_STUDENT_SUBJECT_MAP = new LinkedHashMap();

        GG_STUDENT_SUBJECT_MAP.put("yuwen", "语文");
        GG_STUDENT_SUBJECT_MAP.put("shuxue", "数学");
        GG_STUDENT_SUBJECT_MAP.put("yingyu", "英语");

        KJGL_WLJK_MAP = new LinkedHashMap();

        KJGL_WLJK_MAP.put(Integer.valueOf(1), "数字型");
        KJGL_WLJK_MAP.put(Integer.valueOf(3), "字符型");
        KJGL_WLJK_MAP.put(Integer.valueOf(12), "图片型");
        KJGL_WLJK_MAP.put(Integer.valueOf(15), "附件型");

        GG_DBZSCG_LB_MAP = new LinkedHashMap();

        GG_DBZSCG_LB_MAP.put(Integer.valueOf(1), "一般联系人");
        GG_DBZSCG_LB_MAP.put(Integer.valueOf(2), "负责人");
        GG_DBZSCG_LB_MAP.put(Integer.valueOf(3), "职业人员");

        GG_DBZSCG_XMLX_HW = Integer.valueOf(1);
        GG_DBZSCG_XMLX_GC = Integer.valueOf(2);
        GG_DBZSCG_XMLX_FW = Integer.valueOf(3);
        GG_DBZSCG_XMLX_MAP = new LinkedHashMap();
    }
}
