package com.walker.jdbc.generator.db;

import com.walker.jdbc.generator.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Table {

    private String schem;
    private String name;
    private Column primaryKeyColumn;
    private List<Column> columns;
    private List<Fk> exportedKeysList;
    private List<Fk> importedKeysList;
    private String comment;
    private static final Logger log = LoggerFactory.getLogger(Table.class);

    public Table(Map tableMap) {
        this.columns = new ArrayList();
        this.exportedKeysList = new ArrayList();
        this.importedKeysList = new ArrayList();

        this.schem = StringUtils.safeToString(tableMap.get("TABLE_SCHEM"));
        this.name = StringUtils.safeToString(tableMap.get("TABLE_NAME")).toUpperCase();
        this.comment = StringUtils.safeToString(tableMap.get("REMARKS"));
    }

    public void addColumu(Column column) {
        this.columns.add(column);
    }

    public void addPrimaryKeyColumn(String pk) {
        if (getPrimaryKeyColumn() != null) {
            System.err.println("Table[" + getName() + "] 含有重复主键");
        }
        this.primaryKeyColumn = deleteColumn(pk);
    }

    public void addExportedKey(Map map) {
        this.exportedKeysList.add(new Fk(map));
    }

    public void addImportedKey(Map map) {
        Fk fk = new Fk(map);
        Column column = deleteColumn(fk.getFkcolumn_name());
        if (column != null) {
            fk.setNot_null(column.getNot_null());
            this.importedKeysList.add(fk);
        } else {
            log.error("Table[" + getName() + "]  主键和外键重复(" + fk.getFkcolumn_name() + ")！");
        }
    }

    public String getName()
    {
        return this.name;
    }

    public Column getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public String getSchem() {
        return this.schem;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    private Column deleteColumn(String comumnName) {
        for (int i = 0; i < this.columns.size(); i++) {
            if (((Column)this.columns.get(i)).getName().equals(comumnName)) {
                return (Column)this.columns.remove(i);
            }
        }
        return null;
    }

    public List<Fk> getExportedKeysList() {
        return this.exportedKeysList;
    }

    public List<Fk> getImportedKeysList() {
        return this.importedKeysList;
    }

    public String getComment() {
        return this.comment;
    }
}
