package com.walker.jdbc.generator.util;

public class StringUtils {

    private static final String TEXT_UNDERLINE = "_";
    private static final char CHAR_UNDERLINE = '_';
    private static final String TEXT_EMPTY = "";

    /**
     * 把带下划线的字符串，转换成JAVA驼峰式字符串。
     * <pre>
     *     如：sm_my_name --> SmMyName
     * </pre>
     * @param underlineName 原始字符串
     * @param upperFirstChar 首字母是否大写
     * @return
     * @author 时克英
     * @date 2023-03-23
     */
    public static final String transferUnderlineName2Camel(String underlineName, boolean upperFirstChar){
        if(underlineName == null || underlineName.equals(TEXT_EMPTY)){
            throw new IllegalArgumentException("underlineName不能为空!");
        }
        int index = underlineName.indexOf(TEXT_UNDERLINE);
        if(index == 0){
            // 首字母就是下划线，不处理
            return underlineName;

        } else if(index < 0){
            // 没有找到下划线，默认首字母大写
            if(upperFirstChar){
                return toUpperCaseFirst(underlineName);
            } else {
                return underlineName;
            }

        } else {
            // 存在至少一个下划线
            StringBuilder text = new StringBuilder();
            int count = underlineName.length();
            char c = 0;
            int startUpperCase = 0;
            for(int i=0; i<count; i++){
                c = underlineName.charAt(i);
                if(startUpperCase == 0){
                    if(i == 0){
                        if(upperFirstChar){
                            text.append(String.valueOf(c).toUpperCase());
                        } else {
                            text.append(c);
                        }
                    } else {
                        text.append(String.valueOf(c).toUpperCase());
                    }
                    startUpperCase ++;
                    continue;
                }
                if(c == CHAR_UNDERLINE){
                    // 下划线，复位计数器，不写入字符串
                    startUpperCase = 0;
                    continue;
                }
                // 其他字符串正常写入
                text.append(c);
            }
            return text.toString();
        }
    }

    public static int intValue(Object obj)
    {
        if (obj == null) {
            return 0;
        }
        if ((obj instanceof Number)) {
            return ((Number)obj).intValue();
        }
        return Integer.parseInt(obj.toString());
    }

    public static boolean isEmpty(String str)
    {
        return (str == null) || (TEXT_EMPTY.equals(str));
    }

    public static boolean isNotEmpty(String str) {
        return !isEmpty(str);
    }

    public static String join(String[] src, String separator, String quot) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < src.length; i++) {
            if ((i > 0) && (separator != null)) {
                sb.append(separator);
            }
            if (quot != null) {
                sb.append(quot);
            }
            sb.append(src[i]);
            if (quot != null) {
                sb.append(quot);
            }
        }
        return sb.toString();
    }

    public static String safeToString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static String les(Object obj, int len)
    {
        if ((obj == null) || (obj.toString() == null)) {
            return null;
        }
        if (obj.toString().length() > len) {
            return obj.toString().substring(0, len);
        }
        return obj.toString();
    }

    public static String toLowerCaseFirst(String str)
    {
        if (isEmpty(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        chs[0] = Character.toLowerCase(chs[0]);
        return String.valueOf(chs);
    }

    public static String toUpperCaseFirst(String str) {
        if (isEmpty(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        chs[0] = Character.toUpperCase(chs[0]);
        return String.valueOf(chs);
    }

    public static String getJavaType(String strTemp) {
        String strJavaType = "";
        strTemp = strTemp.toLowerCase();
        System.out.print(strTemp);
        if(strTemp.indexOf("bigint") >= 0){
            strJavaType = "Long";
        } else if (strTemp.indexOf("int") >= 0 || strTemp.indexOf("tinyint") >= 0)
            strJavaType = "Integer";
        else if (strTemp.indexOf("longtext") >= 0) {
            strJavaType = "String";
        } else if (strTemp.indexOf("varchar") >= 0) {
            strJavaType = "String";
        } else if (strTemp.indexOf("long") >= 0)
            strJavaType = "Long";
        else if (strTemp.indexOf("float") >= 0)
            strJavaType = "Float";
        else if (strTemp.indexOf("double") >= 0)
            strJavaType = "Double";
        else if (strTemp.indexOf("boolean") >= 0 || strTemp.indexOf("bit") >= 0)
            strJavaType = "Boolean";
        else if (strTemp.indexOf("string") >= 0)
            strJavaType = "String";
        else if (strTemp.indexOf("date") >= 0)
            strJavaType = "java.util.Date";
        else if (strTemp.indexOf("clob") >= 0)
            strJavaType = "String";
        else if (strTemp.indexOf("text") >= 0)
            strJavaType = "String";
        else if (strTemp.indexOf("blob") >= 0)
            strJavaType = "String";
        else if (strTemp.indexOf("char") >= 0)
            strJavaType = "String";
        else if (strTemp.indexOf("number") >= 0)
            strJavaType = "Integer";
        else if (strTemp.indexOf("materialized_clob") >= 0)
            strJavaType = "String";
        else if (strTemp.indexOf("materialized_blob") >= 0)
            strJavaType = "byte[]";
        else if (strTemp.indexOf("big_decimal") >= 0 || strTemp.indexOf("decimal") >= 0)
            strJavaType = "java.math.BigDecimal";
        else if (strTemp.indexOf("numeric") >= 0)
            strJavaType = "Double";
        else {
            throw new RuntimeException(strTemp + "没有对应的java类型！");
        }

        return strJavaType;
    }

    public static void main(String[] args){
//        String input = "s_user_core";
//        String input = "_show_error";
//        String input = "Thisnone";
//        String input = "create_time";
//        String input = "etaa_question_type";
        String input = "etaa_question_";
        String result = transferUnderlineName2Camel(input, false);
        System.out.println(result);
    }
}
