/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.generator.db;

import com.walker.jdbc.generator.db.Column;
import com.walker.jdbc.generator.db.Fk;
import com.walker.jdbc.generator.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table {
    private String schem;
    private String name;
    private Column primaryKeyColumn;
    private List<Column> columns = new ArrayList<Column>();
    private List<Fk> exportedKeysList = new ArrayList<Fk>();
    private List<Fk> importedKeysList = new ArrayList<Fk>();
    private String comment;
    private static final Logger log = LoggerFactory.getLogger(Table.class);

    public Table(Map tableMap) {
        this.schem = StringUtils.safeToString(tableMap.get("TABLE_SCHEM"));
        this.name = StringUtils.safeToString(tableMap.get("TABLE_NAME")).toUpperCase();
        this.comment = StringUtils.safeToString(tableMap.get("REMARKS"));
    }

    public void addColumu(Column column) {
        this.columns.add(column);
    }

    public void addPrimaryKeyColumn(String pk) {
        if (this.getPrimaryKeyColumn() != null) {
            System.err.println("Table[" + this.getName() + "] \u542b\u6709\u91cd\u590d\u4e3b\u952e");
        }
        this.primaryKeyColumn = this.deleteColumn(pk);
    }

    public void addExportedKey(Map map) {
        this.exportedKeysList.add(new Fk(map));
    }

    public void addImportedKey(Map map) {
        Fk fk = new Fk(map);
        Column column = this.deleteColumn(fk.getFkcolumn_name());
        if (column != null) {
            fk.setNot_null(column.getNot_null());
            this.importedKeysList.add(fk);
        } else {
            log.error("Table[" + this.getName() + "]  \u4e3b\u952e\u548c\u5916\u952e\u91cd\u590d(" + fk.getFkcolumn_name() + ")\uff01");
        }
    }

    public String getName() {
        return this.name;
    }

    public Column getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public String getSchem() {
        return this.schem;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    private Column deleteColumn(String comumnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).getName().equals(comumnName)) continue;
            return this.columns.remove(i);
        }
        return null;
    }

    public List<Fk> getExportedKeysList() {
        return this.exportedKeysList;
    }

    public List<Fk> getImportedKeysList() {
        return this.importedKeysList;
    }

    public String getComment() {
        return this.comment;
    }
}

