/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.generator.util;

import com.walker.jdbc.generator.GenerateException;
import com.walker.jdbc.generator.util.GenUtils;
import com.walker.jdbc.generator.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenPoUtils {
    private static final Logger logger = LoggerFactory.getLogger(GenPoUtils.class);
    public static final String PACKAGE_MODULE = "iplatform";

    public static List<String> getTemplates(String mbbs, boolean platformTable) {
        ArrayList<String> templates = new ArrayList<String>();
        if (mbbs.contains("to")) {
            templates.add("potemplate/vo.vm");
        }
        if (mbbs.contains("mapper")) {
            if (platformTable) {
                templates.add("potemplate/mapper.vm");
            } else {
                templates.add("potemplate/mapper-camel.vm");
            }
        }
        if (mbbs.contains("po")) {
            if (platformTable) {
                templates.add("potemplate/po-new.vm");
            } else {
                templates.add("potemplate/po-camel.vm");
            }
        }
        return templates;
    }

    public static void generatorCode(String mbbs, String table_name, String pk_name, String pk_type, List<Map<String, Object>> columns, ZipOutputStream zip) {
        Properties prop = new Properties();
        prop.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init((Properties)prop);
        table_name = table_name.toLowerCase();
        boolean platformTable = table_name.startsWith("s_");
        VelocityContext context = new VelocityContext();
        Configuration config = GenUtils.getConfig();
        context.put("columns", columns);
        context.put("table_name", (Object)table_name);
        context.put("pk_name", (Object)pk_name);
        context.put("pk_type", (Object)pk_type);
        context.put("stringUtils", (Object)new StringUtils());
        List<String> templates = GenPoUtils.getTemplates(mbbs, platformTable);
        try {
            for (String template : templates) {
                StringWriter sw = new StringWriter();
                Template tpl = Velocity.getTemplate((String)template, (String)"UTF-8");
                tpl.merge((Context)context, (Writer)sw);
                zip.putNextEntry(new ZipEntry(GenPoUtils.getFileName(template, table_name)));
                IOUtils.write((String)sw.toString(), (OutputStream)zip, (String)"UTF-8");
                IOUtils.closeQuietly((Writer)sw);
            }
        }
        catch (IOException e) {
            throw new GenerateException("\u6e32\u67d3\u6a21\u677f\u5931\u8d25\uff0c\u8868\u540d\uff1a" + table_name, e);
        }
    }

    public static String getFileName(String template, String table_name) {
        logger.debug("template = {},", (Object)template);
        String table_name_u = null;
        table_name_u = table_name.startsWith("s_") ? StringUtils.toUpperCaseFirst(table_name) : StringUtils.transferUnderlineName2Camel(table_name, true);
        logger.debug("table_name_u = {}", (Object)table_name_u);
        String packagePath = "main" + File.separator + "java" + File.separator + "com" + File.separator + PACKAGE_MODULE + File.separator + "model";
        String[] ts = template.split("/");
        String template_name = ts[1];
        if (template_name.equals("po.vm")) {
            return packagePath + File.separator + "po" + File.separator + table_name_u + ".java";
        }
        if (template_name.equals("po-new.vm") || template_name.equals("po-camel.vm")) {
            return packagePath + File.separator + "po" + File.separator + table_name_u + ".java";
        }
        if (template_name.equals("vo.vm")) {
            return packagePath + File.separator + "to" + File.separator + table_name_u + "_t.java";
        }
        if (template_name.equals("mapper.vm") || template_name.equals("mapper-camel.vm")) {
            return packagePath + File.separator + "mapper" + File.separator + table_name_u + "_mapper.java";
        }
        return null;
    }
}

