package com.walker.es;

import java.util.List;

/**
 * 全文检索，ES分页索引对象定义。
 * <p>用于前端分页展示</p>
 * @author 时克英
 * @date 2023-08-02
 */
public class PageIndex<T> {

    private int pageNum = 1;
    private int pageSize = 20;

    /**
     * 当前页码数
     * @return
     */
    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    /**
     * 返回分页大小
     * @return
     */
    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * 返回上一页最后一条记录排序值，ES深度分页需要提供上一页最后一条记录的排序值。
     * <p>用于下一页</p>
     * @return
     */
    public String getLastValue() {
        return lastValue;
    }

    public void setLastValue(String lastValue) {
        this.lastValue = lastValue;
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public List<T> getData() {
        return data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    protected List<T> data;

    /**
     * 返回本页第一个数据，用于返回上一页
     * @return
     */
    public String getFirstValue() {
        return firstValue;
    }

    public void setFirstValue(String firstValue) {
        this.firstValue = firstValue;
    }

    private String firstValue;
    private long total = 0;
    private String lastValue;

    @Override
    public String toString() {
        return "PageIndex{" +
                "pageNum=" + pageNum +
                ", pageSize=" + pageSize +
                ", total=" + total +
                ", lastValue='" + lastValue + '\'' +
                '}';
    }
}
