/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.mongo;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.walker.db.Sorts;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.StringUtils;
import java.util.List;
import org.bson.Document;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.lang.Nullable;

public class MongoService {
    private MongoTemplate mongoTemplate;
    public static final String KEY_ID_DEFAULT = "_id";

    public <T> MongoCollection createCollection(Class<T> entity) {
        return this.mongoTemplate.createCollection(entity);
    }

    public void createCollection(String name) {
        this.mongoTemplate.createCollection(name);
    }

    public <T> void dropCollection(Class<T> entity) {
        this.mongoTemplate.dropCollection(entity);
    }

    public void dropCollection(String tableName) {
        this.mongoTemplate.dropCollection(tableName);
    }

    public <T> void insert(T data, String tableName) {
        this.mongoTemplate.insert(data, tableName);
    }

    public <T> void insert(T data) {
        this.mongoTemplate.insert(data);
    }

    public <T> void insertBatch(List<T> data, Class<T> entity) {
        this.mongoTemplate.insert(data, entity);
    }

    public <T> void insertBatch(List<T> data, String tableName) {
        this.mongoTemplate.insert(data, tableName);
    }

    public long deleteById(String id, String tableName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)KEY_ID_DEFAULT).is((Object)id));
        DeleteResult deleteResult = this.mongoTemplate.remove(query, tableName);
        if (deleteResult != null) {
            return deleteResult.getDeletedCount();
        }
        return 0L;
    }

    public <T> long deleteById(String id, Class<T> entity) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)KEY_ID_DEFAULT).is((Object)id));
        DeleteResult deleteResult = this.mongoTemplate.remove(query, entity);
        if (deleteResult != null) {
            return deleteResult.getDeletedCount();
        }
        return 0L;
    }

    public UpdateResult updateById(String id, String column, Object value, String tableName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)KEY_ID_DEFAULT).is((Object)id));
        Update update = new Update();
        update.set(column, value);
        UpdateResult updateResult = this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, tableName);
        return updateResult;
    }

    public <T> UpdateResult updateById(String id, String column, Object value, Class<T> entity) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)KEY_ID_DEFAULT).is((Object)id));
        Update update = new Update();
        update.set(column, value);
        UpdateResult updateResult = this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, entity);
        return updateResult;
    }

    public <T> UpdateResult updateEntity(String id, T data) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)KEY_ID_DEFAULT).is((Object)id));
        Document document = (Document)this.mongoTemplate.getConverter().convertToMongoType(data);
        Update update = Update.fromDocument((Document)document, (String[])new String[0]);
        UpdateResult updateResult = this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, data.getClass());
        return updateResult;
    }

    public <T> UpdateResult updateEntity(String id, T data, String tableName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)KEY_ID_DEFAULT).is((Object)id));
        Document document = (Document)this.mongoTemplate.getConverter().convertToMongoType(data);
        Update update = Update.fromDocument((Document)document, (String[])new String[0]);
        UpdateResult updateResult = this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, tableName);
        return updateResult;
    }

    public <T> List<T> queryList(Query query, Class<T> entity, @Nullable String tableName, @Nullable Sorts.Sort sorts) {
        if (sorts != null) {
            if (sorts.isAsc()) {
                query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)sorts.getField())}));
            } else {
                query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)sorts.getField())}));
            }
        }
        List data = null;
        data = StringUtils.isEmpty((String)tableName) ? this.mongoTemplate.find(query, entity) : this.mongoTemplate.find(query, entity, tableName);
        return data;
    }

    public <T> GenericPager<T> queryPageList(Query query, Class<T> entity, @Nullable String tableName, PageSearch pageSearch, @Nullable Sorts.Sort sorts) {
        query.with((Pageable)PageRequest.of((int)(pageSearch.getPageIndex() - 1), (int)pageSearch.getPageSize()));
        if (sorts != null) {
            if (sorts.isAsc()) {
                query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)sorts.getField())}));
            } else {
                query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)sorts.getField())}));
            }
        }
        long total = 0L;
        List data = null;
        if (StringUtils.isEmpty((String)tableName)) {
            total = this.mongoTemplate.count(query, entity);
            data = this.mongoTemplate.find(query, entity);
        } else {
            total = this.mongoTemplate.count(query, entity, tableName);
            data = this.mongoTemplate.find(query, entity, tableName);
        }
        return ListPageContext.createGenericPager((List)data, (int)pageSearch.getPageIndex(), (int)pageSearch.getPageSize(), (int)((int)total));
    }

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

