/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.mongo.MongoProperty;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;

public class MongoTemplateFactory {
    public MongoTemplate createTemplate(MongoProperty mongoProperty) {
        return this.createTemplate(mongoProperty.getIp(), mongoProperty.getPort(), mongoProperty.getDatabase(), mongoProperty.getUserName(), mongoProperty.getPassword(), mongoProperty.getMaxSize(), mongoProperty.getMinSize(), mongoProperty.getMaxIdleTimeSeconds(), mongoProperty.getMaxWaitTimeSeconds());
    }

    public MongoTemplate createTemplate(String ip, int port, String database, String userName, String password, int maxSize, int minSize, long maxIdleTimeSeconds, long maxWaitTimeSeconds) {
        if (StringUtils.isEmpty((String)ip) || StringUtils.isEmpty((String)database)) {
            throw new IllegalArgumentException("ip, database\u5fc5\u987b\u8bbe\u7f6e");
        }
        ServerAddress serverAddress = new ServerAddress(ip, port);
        MongoClientSettings settings = MongoClientSettings.builder().applyToClusterSettings(builder -> builder.hosts(Arrays.asList(serverAddress))).credential(MongoCredential.createCredential((String)userName, (String)database, (char[])password.toCharArray())).applyToConnectionPoolSettings(builder -> builder.maxSize(maxSize).minSize(minSize).maxConnectionIdleTime(maxIdleTimeSeconds, TimeUnit.SECONDS).maxWaitTime(maxWaitTimeSeconds, TimeUnit.SECONDS)).build();
        MongoClient mongoClient = MongoClients.create((MongoClientSettings)settings);
        SimpleMongoClientDatabaseFactory dbFactory = new SimpleMongoClientDatabaseFactory(mongoClient, database);
        return new MongoTemplate((MongoDatabaseFactory)dbFactory);
    }
}

