package com.walker.jdbc.mongo;

import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Field;

/**
 * 聊天记录对象定义。
 * @author 时克英
 * @date 2023-07-06
 */
public class ChatRecord {

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getCreateDate() {
        return createDate;
    }

    public void setCreateDate(long createDate) {
        this.createDate = createDate;
    }

    public long getUserId() {
        return userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getMsgType() {
        return msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    /**
     * 对话ID，用于区别每一次对话，可以通过传入该参数，查询每个对话全部内容。
     * <p>该属性由业务层定义，在客服系统中，用户能关闭对话，此时生成一个完整对话内容。</p>
     * @return
     * @date 2023-09-06
     */
    public String getDialogId() {
        return dialogId;
    }

    public void setDialogId(String dialogId) {
        this.dialogId = dialogId;
    }

    @Indexed(unique=false)
    @Field("dialog_id")
    private String dialogId;

    @Indexed(unique=false)
    @Field("biz_id")
    private String bizId;

    @Id
    private String id;

    @CreatedDate
    @Field("create_time")
    private long createDate;

    // 聊天对方ID
    @Indexed(unique=false)
    @Field("user_id")
    private long userId;

    // 类型：发送或接收
    private int type = TYPE_SEND;

    @Field("msg_type")
    private String msgType = MSG_TYPE_TEXT;

    private String message;

    public static final int TYPE_SEND = 0;
    public static final int TYPE_RECEIVED = 1;

    public static final String MSG_TYPE_TEXT = "text";

    @Override
    public String toString() {
        return "ChatRecord{" +
                "id='" + id + '\'' +
                ", createDate=" + createDate +
                ", userId=" + userId +
                ", type=" + type +
                ", msgType='" + msgType + '\'' +
                ", message='" + message + '\'' +
                '}';
    }
}
