package com.walker.jdbc;

import com.walker.db.DatabaseType;

public class Constants {

    public static final String SQL_ORDER_BY = " order by ";

    public static final String getJdbcUrl(DatabaseType databaseType, String databaseName, String ip, int port){
        StringBuilder url = new StringBuilder();
        if(databaseType == DatabaseType.DERBY){
            url.append("jdbc:derby:").append(databaseName);

        } else if(databaseType == DatabaseType.MYSQL){
            url.append("jdbc:mysql://").append(ip).append(":")
                    .append(port == 0 ? Constants.DEFAULT_PORT_MYSQL : port)
                    .append("/").append(databaseName);
            // 因为oracle不支持这样设置参数，所以位置调换到这里 2016-11-30
            if(url.indexOf("?") >= 0){
//                url.append("&amp;autoReconnect=true");		//当数据库连接异常中断时，是否自动重新连接
//                url.append("&amp;failOverReadOnly=false");	//自动重连成功后，连接是否设置为只读
                url.append("&autoReconnect=true");		//当数据库连接异常中断时，是否自动重新连接
                url.append("&failOverReadOnly=false");	//自动重连成功后，连接是否设置为只读
            } else {
                url.append("?autoReconnect=true");
//                url.append("&amp;failOverReadOnly=false");
                url.append("&failOverReadOnly=false");
            }

        } else if(databaseType == DatabaseType.ORACLE){
            url.append("jdbc:oracle:thin:@").append(ip).append(":")
                    .append(port == 0 ? Constants.DEFAULT_PORT_ORACLE : port)
                    .append(":").append(databaseName);

        } else if(databaseType == DatabaseType.POSTGRES){
            url.append("jdbc:postgresql://").append(ip).append(":")
                    .append(port == 0 ? Constants.DEFAULT_PORT_POSTGRES : port)
                    .append("/").append(databaseName);

        } else if(databaseType == DatabaseType.SQLSERVER){
            url.append("jdbc:sqlserver://").append(ip).append(":")
                    .append(port == 0 ? Constants.DEFAULT_PORT_POSTGRES : port)
                    .append(";DatabaseName=").append(databaseName);

        } else if(databaseType == DatabaseType.DAMENG){
            url.append("jdbc:dm://").append(ip).append(":")
                    .append(port == 0 ? Constants.DEFAULT_PORT_POSTGRES : port)
                    .append("?SCHEMA=").append(databaseName);
        } else
            throw new IllegalArgumentException("unsupported database type: " + databaseType);
        return url.toString();
    }

    public static final String getDriverClassName(DatabaseType databaseType){
        String driverName = null;
        if(databaseType == DatabaseType.DERBY){
            driverName = Constants.DRIVER_NAME_DERBY;
        } else if(databaseType == DatabaseType.MYSQL){
            driverName = Constants.DRIVER_NAME_MYSQL;
        } else if(databaseType == DatabaseType.ORACLE){
            driverName = Constants.DRIVER_NAME_ORACLE;
        } else if(databaseType == DatabaseType.POSTGRES){
            driverName = Constants.DRIVER_NAME_POSTGRES;
        } else if(databaseType == DatabaseType.SQLSERVER){
            driverName = Constants.DRIVER_NAME_SQLSERVER;
        } else if(databaseType == DatabaseType.DAMENG){
            driverName = Constants.DRIVER_NAME_DAMENG;
        } else
            throw new IllegalArgumentException("unsupported database type: " + databaseType);
        return driverName;
    }

    public static final String DRIVER_NAME_DERBY = "org.apache.derby.jdbc.EmbeddedDriver";
    //    public static final String DRIVER_NAME_MYSQL = "com.mysql.jdbc.Driver";
    public static final String DRIVER_NAME_MYSQL = "com.mysql.cj.jdbc.Driver";
    public static final String DRIVER_NAME_ORACLE = "oracle.jdbc.driver.OracleDriver";
    public static final String DRIVER_NAME_POSTGRES = "org.postgresql.Driver";
    public static final String DRIVER_NAME_SQLSERVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String DRIVER_NAME_DAMENG = "dm.jdbc.driver.DmDriver";

    public static final int DEFAULT_PORT_DERBY = 0;
    public static final int DEFAULT_PORT_MYSQL = 3306;
    public static final int DEFAULT_PORT_ORACLE = 1521;
    public static final int DEFAULT_PORT_POSTGRES = 5432;
    public static final int DEFAULT_PORT_SQLSERVER = 1433;
    public static final int DEFAULT_PORT_DAMENG = 5236;

    /**
     * PO中加入的'parameter'(Map)字段名字。
     * @date 2023-03-24
     */
    public static final String PO_FIELD_PARAMETER = "parameter";

    public static final String SQL_NAME_WHERE = "where";
    public static final String SQL_NAME_AND = "and";
    public static final String SQL_NAME_LIKE = "like";
}
