package com.walker.jdbc;

import com.walker.db.DatabaseType;

/**
 * 获取数据库额外信息的元数据定义。
 * @date 2022-08-12
 * @author 时克英
 */
public interface DataSourceMeta {

    /**
     * 获得数据源库用户名
     * @return
     */
    String getUsername();

    /**
     * 获得数据库密码
     * @return
     */
    String getPassword();

    /**
     * 获得数据库类型
     * @return
     */
    DatabaseType getDatabaseType();

    /**
     * 获得连接数据库URL原始内容
     * @return
     */
    String getUrl();

    /**
     * 获得连接数据库名字
     * @return
     */
    String getDatabaseName();

    String getIp();

    int getPort();

    void setUsername(String username);

    void setPassword(String password);
}
