package com.walker.jdbc;

import com.walker.db.DatabaseType;
import com.walker.security.SystemLogMan;

/**
 * 存储系统数据库相关的关键信息，方便业务查看并使用。
 * @author 时克英
 * @date 2022-08-18
 */
public class JdbcInspector {

    private DatabaseType primaryDatabaseType = null;

    private DataSourceMeta primaryDataSourceMeta = null;

    private static JdbcInspector instance;

    private JdbcInspector(){}

    public static JdbcInspector getInstance(){
        SystemLogMan.getInstance().checkMan();
        if(instance == null){
            instance = new JdbcInspector();
        }
        return instance;
    }

    public DatabaseType getPrimaryDatabaseType() {
        return primaryDatabaseType;
    }

    public void setPrimaryDatabaseType(DatabaseType primaryDatabaseType) {
        if(primaryDatabaseType == null){
            throw new IllegalArgumentException("primaryDatabaseType已经存在");
        }
        this.primaryDatabaseType = primaryDatabaseType;
    }

    public DataSourceMeta getPrimaryDataSourceMeta() {
        return primaryDataSourceMeta;
    }

    public void setPrimaryDataSourceMeta(DataSourceMeta primaryDataSourceMeta) {
        if(primaryDataSourceMeta == null){
            throw new IllegalArgumentException("primaryDataSourceMeta已经存在");
        }
        this.primaryDataSourceMeta = primaryDataSourceMeta;
    }

}
