package com.walker.jdbc.service;

import com.walker.jdbc.BaseDao;
import com.walker.jdbc.BasePo;

import java.util.List;

/**
 * 服务类基础接口
 *
 * @author 时克英
 * @date 2017年3月2日
 */
public interface BaseService extends BaseDao {

    /**
     * 保存一组数据, 主键不空则更新，主键为空则插入
     *
     * @param listPo 需要保存或更新的PO数组
     * @param <T>    BasePo子类
     * @return 影响的数据行数
     */
    <T extends BasePo<T>> int save(List<T> listPo);

    /**
     * 查询全部数据
     *
     * @param po  需要查询的PO
     * @param <T> BasePo子类
     * @return 全部数据
     */
    <T extends BasePo<T>> List<T> selectAll(T po);

    /**
     * 获取最大顺序号
     *
     * @param tableName 表名
     * @param pidName   父表关联字段
     * @param pid       父id
     * @return 最大的顺序号
     */
    int getMaxOrder(String tableName, String pidName, String pid);


    /**
     * 保存顺序号
     *
     * @param tableName 表名
     * @param ids       表主键
     */
    void saveOrder(String tableName, String[] ids);
}
