package com.walker.jdbc.service;

import com.walker.common.util.ConvertUtil;
import com.walker.common.util.MapBuilder;
import com.walker.db.Sorts;
import com.walker.db.page.GenericPager;
import com.walker.db.page.MapPager;
import com.walker.jdbc.BaseDao;
import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.util.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 服务类基础实现
 *
 * @author 时克英
 * @date 2017年3月2日
 */
public  class BaseServiceImpl implements BaseService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Autowired
    @Qualifier("dao")
    protected BaseDao dao;

    private <T extends BasePo<T>> BaseMapper<T> convertToMapper(T basePo) {
//        return PoMapperFactory.getInstance(basePo);
        return JdbcUtils.getInstance(basePo);
    }

    @Override
    public <T extends BasePo<T>> int save(T po) {
        return this.dao.save(po);
    }

    /**
     * @see com.walker.jdbc.service.BaseService#save(List<T> )
     */
    @Override
    public <T extends BasePo<T>> int save(List<T> listPo) {
        int sum = 0;
        for (T po : listPo) {
            sum += this.save(po);
        }
        return sum;
    }

    protected BaseDao getDao() {
        return dao;
    }

    /**
     * 从外部由系统统一构建并传入单例。
     * @param dao
     */
    public void setDao(BaseDao dao) {
        this.dao = dao;
    }

    /**
     * @see com.walker.jdbc.BaseDao#insert(T)
     */
    @Override
    public <T extends BasePo<T>> int insert(T po) throws DataAccessException {
        return dao.insert(po);
    }

    /**
     * @see com.walker.jdbc.BaseDao#insert(List<T> )
     */
    @Override
    public <T extends BasePo<T>> int insert(List<T> poList) throws DataAccessException {
        return dao.insert(poList);
    }

    @Override
    public <T extends BasePo<T>> int insertBatch(List<T> poList) throws DataAccessException {
        return dao.insertBatch(poList);
    }

    /**
     * @see com.walker.jdbc.BaseDao#update(T)
     */
    @Override
    public <T extends BasePo<T>> int update(T po) throws DataAccessException {
        return dao.update(po);
    }

    /**
     * @see com.walker.jdbc.BaseDao#update(List<T> )
     */
    @Override
    public <T extends BasePo<T>> int update(List<T> poList) throws DataAccessException {
        return dao.update(poList);
    }

    @Override
    public <T extends BasePo<T>> int updateBatch(List<T> poList) throws DataAccessException {
        return dao.updateBatch(poList);
    }

    /**
     * @see com.walker.jdbc.BaseDao#update(T, String, Map< String, Object> )
     */
    @Override
    public <T extends BasePo<T>> int update(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        return dao.update(po, where, parameters);
    }

    @Override
    public <T extends BasePo<T>> int update(T po, String where, Object[] parameters) throws DataAccessException {
        return dao.update(po, where, parameters);
    }

    /**
     * @see com.walker.jdbc.BaseDao#delete(T)
     */
    @Override
    public <T extends BasePo<T>> int delete(T po) throws DataAccessException {
        return dao.delete(po);
    }

    /**
     * @see com.walker.jdbc.BaseDao#delete(List<T> )
     */
    @Override
    public <T extends BasePo<T>> int delete(List<T> poList) throws DataAccessException {
        return dao.delete(poList);
    }

    /**
     * @see com.walker.jdbc.BaseDao#delete(T, String, Map< String, Object> )
     */
    @Override
    public <T extends BasePo<T>> int delete(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        return dao.delete(po, where, parameters);
    }

    @Override
    public <T extends BasePo<T>> int delete(T po, String where, Object[] parameters) throws DataAccessException {
        return dao.delete(po, where, parameters);
    }

    /**
     * @see com.walker.jdbc.BaseDao#get(T)
     */
    @Override
    public <T extends BasePo<T>> T get(T po) throws DataAccessException {
        return dao.get(po);
    }

    /**
     * @see com.walker.jdbc.BaseDao#get(T, String, Map< String, Object> )
     */
    @Override
    public <T extends BasePo<T>> T get(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        return dao.get(po, where, parameters);
    }

    @Override
    public <T extends BasePo<T>> T get(T po, String where, Object[] parameters) throws DataAccessException {
        return dao.get(po, where, parameters);
    }

    @Override
    public <T> T get(String sql, Map<String, Object> parameters, RowMapper<T> rowMapper) throws DataAccessException {
        return this.dao.get(sql, parameters, rowMapper);
    }

    @Override
    public <T extends BasePo<T>> T get(String sql, Map<String, Object> parameters, T po) throws DataAccessException {
        return this.dao.get(sql, parameters, po);
    }

    @Override
    public <T> T get(String sql, Object[] parameters, RowMapper<T> rowMapper) throws DataAccessException {
        return this.dao.get(sql, parameters, rowMapper);
    }

    @Override
    public <T extends BasePo<T>> T get(String sql, Object[] parameters, T po) throws DataAccessException {
        return this.dao.get(sql, parameters, po);
    }

    /**
     * @see com.walker.jdbc.BaseDao#get(String, Map< String, Object> )
     */
    @Override
    public Map<String, Object> get(String sql, Map<String, Object> parameters) throws DataAccessException {
        return dao.get(sql, parameters);
    }

    /**
     * @see com.walker.jdbc.BaseDao#get(String, Object[])
     */
    @Override
    public Map<String, Object> get(String sql, Object[] parameters) throws DataAccessException {
        return dao.get(sql, parameters);
    }

    /**
     * @see com.walker.jdbc.BaseDao#select(T, String, Map< String, Object> )
     */
    @Override
    public <T extends BasePo<T>> List<T> select(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        return dao.select(po, where, parameters);
    }

    /**
     * @see com.walker.jdbc.BaseDao#select(T, String, Object[])
     */
    @Override
    public <T extends BasePo<T>> List<T> select(T po, String where, Object[] parameters) throws DataAccessException {
        return dao.select(po, where, parameters);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(T po) throws DataAccessException {
        return dao.select(po);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(T po, Sorts.Sort sort) throws DataAccessException {
        return this.dao.select(po, sort);
    }

    /**
     * @see com.walker.jdbc.BaseDao#selectSplit(BasePo, String, Map, int, int)
     */
    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, String where
            , Map<String, Object> parameters, int currentPage, int pageSize) throws DataAccessException {
//        return dao.selectSplit(po, where, parameters, splitPageInfo);
        return dao.selectSplit(po, where, parameters, currentPage, pageSize);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, int currentPage, int pageSize) throws DataAccessException {
        return dao.selectSplit(po, currentPage, pageSize);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, int currentPage, int pageSize, Sorts.Sort sort) throws DataAccessException {
        return this.dao.selectSplit(po, currentPage, pageSize, sort);
    }

    /**
     * @see com.walker.jdbc.BaseDao#select(String, Object[])
     */
    @Override
    public List<Map<String, Object>> select(String sql, Object[] parameters) throws DataAccessException {
        return dao.select(sql, parameters);
    }

    /**
     * @see com.walker.jdbc.BaseDao#select(String, Object[], RowMapper<T> )
     */
    @Override
    public <T> List<T> select(String sql, Object[] parameters, RowMapper<T> mapper) throws DataAccessException {
        return dao.select(sql, parameters, mapper);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(String sql, Object[] parameters, T po) throws DataAccessException {
        return this.dao.select(sql, parameters, po);
    }

    /**
     * @see com.walker.jdbc.BaseDao#selectSplit(String, Object[], int, int)
     */
    @Override
    public MapPager selectSplit(String sql, Object[] parameters, int currentPage, int pageSize) throws DataAccessException {
        return dao.selectSplit(sql, parameters, currentPage, pageSize);
    }

    @Override
    public MapPager selectSplit(String sql, Object[] parameters, int currentPage, int pageSize, Sorts.Sort sort) throws DataAccessException {
        return dao.selectSplit(sql, parameters, currentPage, pageSize, sort);
    }

//    /**
//     * @see com.walker.jdbc.BaseDao#selectSplitEx(String, Object[], com.walker.common.SplitPageInfo)
//     */
//    @Override
//    public SplitPageInfo selectSplitEx(String sql, Object[] parameters, SplitPageInfo splitPageInfo) throws DataAccessException {
//        return this.dao.selectSplitEx(sql, parameters, splitPageInfo);
//    }

    /**
     * @see com.walker.jdbc.BaseDao#selectSplit(String, Object[], int, int, RowMapper<T> )
     */
    @Override
    public <T> GenericPager<T> selectSplit(String sql, Object[] parameters, int currentPage, int pageSize, RowMapper<T> rowMapper) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, rowMapper);
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Object[] parameters, int currentPage, int pageSize, RowMapper<T> rowMapper, Sorts.Sort sort) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, rowMapper, sort);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(String sql, Object[] parameters, int currentPage, int pageSize, T po) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, po);
    }

//    /**
//     * @see com.walker.jdbc.BaseDao#selectSplitEx(String, Object[], com.walker.common.SplitPageInfo, RowMapper<T> )
//     */
//    @Override
//    public <T> SplitPageInfo selectSplitEx(String sql, Object[] parameters, SplitPageInfo splitPageInfo, RowMapper<T> rowMapper) throws DataAccessException {
//        return this.dao.selectSplitEx(sql, parameters, splitPageInfo, rowMapper);
//    }

//    @Override
//    public <T extends BasePo<T>> SplitPageInfo selectSplitEx(String sql, Object[] parameters, SplitPageInfo splitPageInfo, T po) throws DataAccessException {
//        return this.dao.selectSplitEx(sql, parameters, splitPageInfo, po);
//    }

    /**
     * @see com.walker.jdbc.BaseDao#select(String, Map< String, Object> )
     */
    @Override
    public List<Map<String, Object>> select(String sql, Map<String, Object> parameters) throws DataAccessException {
        return dao.select(sql, parameters);
    }

    /**
     * @see com.walker.jdbc.BaseDao#select(String, Map< String, Object>, RowMapper<T> )
     */
    @Override
    public <T> List<T> select(String sql, Map<String, Object> parameters, RowMapper<T> mapper) throws DataAccessException {
        return this.dao.select(sql, parameters, mapper);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(String sql, Map<String, Object> parameters, T po) throws DataAccessException {
        return this.dao.select(sql, parameters, po);
    }

    /**
     * @see com.walker.jdbc.BaseDao#selectSplit(String, Map, int, int)
     */
    @Override
    public MapPager selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize) throws DataAccessException {
        return dao.selectSplit(sql, parameters, currentPage, pageSize);
    }

    @Override
    public MapPager selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize, Sorts.Sort sort) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, sort);
    }

//    @Override
//    public SplitPageInfo selectSplitEx(String sql, Map<String, Object> parameters, SplitPageInfo splitPageInfo) throws DataAccessException {
//        return this.dao.selectSplitEx(sql, parameters, splitPageInfo);
//    }

    /**
     * @see com.walker.jdbc.BaseDao#selectSplit(String, Map, int, int, RowMapper)
     */
    @Override
    public <T> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize, RowMapper<T> rowMapper) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, rowMapper);
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize, RowMapper<T> rowMapper, Sorts.Sort sort) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, rowMapper, sort);
    }

    /**
     * 分页方法添加
     * @date 2023-10-24
     */
    @Override
    public <T> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, RowMapper<T> rowMapper, Sorts.Sort sort) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, rowMapper, sort);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize, T po) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, po);
    }

//    @Override
//    public <T> SplitPageInfo selectSplitEx(String sql, Map<String, Object> parameters, SplitPageInfo splitPageInfo, RowMapper<T> rowMapper) throws DataAccessException {
//        return this.dao.selectSplitEx(sql, parameters, splitPageInfo, rowMapper);
//    }

//    @Override
//    public <T extends BasePo<T>> SplitPageInfo selectSplitEx(String sql, Map<String, Object> parameters, SplitPageInfo splitPageInfo, T po) throws DataAccessException {
//        return this.dao.selectSplitEx(sql, parameters, splitPageInfo, po);
//    }

    /**
     * @see com.walker.jdbc.BaseDao#execute(String, Object[])
     */
    @Override
    public int execute(String sql, Object[] parameters) throws DataAccessException {
        return dao.execute(sql, parameters);
    }

    /**
     * @see com.walker.jdbc.BaseDao#execute(String, Map< String, Object> )
     */
    @Override
    public int execute(String sql, Map<String, Object> parameters) throws DataAccessException {
        return dao.execute(sql, parameters);
    }

    /**
     * @see com.walker.jdbc.BaseDao#queryForInt(String, Object[])
     */
    @Override
    public int queryForInt(String sql, Object[] parameters) throws DataAccessException {
        return dao.queryForInt(sql, parameters);
    }

    /**
     * @see com.walker.jdbc.BaseDao#queryForInt(String, Map< String, Object> )
     */
    @Override
    public int queryForInt(String sql, Map<String, Object> parameters) throws DataAccessException {
        return dao.queryForInt(sql, parameters);
    }

    /**
     * @see com.walker.jdbc.BaseDao#queryForObject(String, Object[], Class<T> )
     */
    @Override
    public <T> T queryForObject(String sql, Object[] parameters, Class<T> clazz) throws DataAccessException {
        return this.dao.queryForObject(sql, parameters, clazz);
    }


    /**
     * @see com.walker.jdbc.BaseDao#queryForObject(String, Map, Class)
     */
    @Override
    public <T> T queryForObject(String sql, Map<String, Object> parameters, Class<T> clazz) throws DataAccessException {
        return dao.queryForObject(sql, parameters, clazz);
    }

    /**
     * @see com.walker.jdbc.BaseDao#execCall(String, Object[])
     */
    @Override
    public void execCall(String functionName, Object[] parameters) throws DataAccessException {
        dao.execCall(functionName, parameters);
    }

    /**
     * @see com.walker.jdbc.BaseDao#execCall(String, Object[], Class<T> )
     */
    @Override
    public <T> T execCall(String functionName, Object[] parameters, Class<T> clazz) throws DataAccessException {
        return dao.execCall(functionName, parameters, clazz);
    }

    /**
     * @see com.walker.jdbc.BaseDao#execBatchUpdate(String, List<?> )
     */
    @Override
    public int execBatchUpdate(String sql, List<?> parametersList) throws DataAccessException {
        return dao.execBatchUpdate(sql, parametersList);
    }

    @Override
    public void update(String sql) {
        dao.update(sql);
    }

    @Override
    public int update(String sql, Object[] args) {
        return dao.update(sql, args);
    }

    @Override
    public <T> List<T> sqlQuery(String sql, RowMapper<T> rowMapper) {
        return dao.sqlQuery(sql, rowMapper);
    }

    @Override
    public <T> List<T> sqlQuery(String sql, Object[] args, RowMapper<T> rowMapper) {
        return dao.sqlQuery(sql, args, rowMapper);
    }

    @Override
    public List<Map<String, Object>> sqlQueryListMap(String sql, Object[] args) {
        return dao.sqlQueryListMap(sql, args);
    }

    @Override
    public <E> GenericPager<E> sqlGeneralQueryPager(String sql, Object[] args, RowMapper<E> rowMapper) {
        return dao.sqlGeneralQueryPager(sql, args, rowMapper);
    }

    @Override
    public <E> GenericPager<E> sqlGeneralQueryPager(String sql, Object[] args, RowMapper<E> rowMapper, int pageIndex) {
        return dao.sqlGeneralQueryPager(sql, args, rowMapper, pageIndex);
    }

    @Override
    public <T> GenericPager<T> sqlGeneralQueryPager(String sql, Object[] args, RowMapper<T> rowMapper, int pageIndex, int pageSize) {
        return dao.sqlGeneralQueryPager(sql, args, rowMapper, pageIndex, pageSize);
    }

    @Override
    public <T> T sqlMathQuery(String sql, Object[] args, Class<T> clazz) {
        return dao.sqlMathQuery(sql, args, clazz);
    }

    @Override
    public <T> List<T> sqlListObjectWhereIn(String sql, RowMapper<T> rowMapper, SqlParameterSource paramSource) {
        return dao.sqlListObjectWhereIn(sql, rowMapper, paramSource);
    }

    @Override
    public List<Map<String, Object>> queryListObjectWhereIn(String sql, SqlParameterSource paramSource){
        return dao.queryListObjectWhereIn(sql, paramSource);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po) throws DataAccessException {
        return dao.selectSplit(po);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, Sorts.Sort sort) throws DataAccessException {
        return dao.selectSplit(po, sort);
    }

    /**
     * @see com.walker.jdbc.service.BaseService#selectAll(T)
     */
    @Override
    public <T extends BasePo<T>> List<T> selectAll(T po) {
        return dao.select("select * from " + this.convertToMapper(po).getTableName_(), new HashMap<String, Object>(), po);
    }

    /**
     * @see com.walker.jdbc.service.BaseService#getMaxOrder(String, String, String)
     */
    @Override
    public int getMaxOrder(String tableName, String pidName, String pid) {
        StringBuilder sql = new StringBuilder("select max(sxh) from ").append(tableName);
        if (pid != null) {
            //为字符串“null”
            if (pid.equals("null")) {
                sql.append(" where ").append(pidName).append(" is null ");
            } else {
                sql.append(" where ").append(pidName).append(" = :pid");
            }
        }
        Object max = dao.queryForObject(sql.toString(), MapBuilder.map("pid", pid), Object.class);
        return ConvertUtil.toInt(max, 0);
    }
//    @Override
//    public <T> List<T> selectSplitOnlyData(String sql, Map<String, Object> parameters, SplitPageInfo splitPageInfo, RowMapper<T> rowMapper) throws DataAccessException {
//        return this.dao.selectSplitOnlyData(sql, parameters, splitPageInfo, rowMapper);
//    }
//
//    @Override
//    public <T extends BasePo<T>> List<T> selectSplitOnlyData(String sql, Map<String, Object> parameters, SplitPageInfo splitPageInfo, T po) throws DataAccessException {
//        return this.dao.selectSplitOnlyData(sql, parameters, splitPageInfo, po);
//    }
//
//    @Override
//    public <T> List<T> selectSplitOnlyData(String sql, Object[] parameters, SplitPageInfo splitPageInfo, RowMapper<T> rowMapper) throws DataAccessException {
//        return this.dao.selectSplitOnlyData(sql, parameters, splitPageInfo, rowMapper);
//    }
//
//    @Override
//    public <T extends BasePo<T>> List<T> selectSplitOnlyData(String sql, Object[] parameters, SplitPageInfo splitPageInfo, T po) throws DataAccessException {
//        return this.dao.selectSplitOnlyData(sql, parameters, splitPageInfo, po);
//    }
//
//    @Override
//    public <T extends BasePo<T>> List<T> selectSplitOnlyData(T po, String where, Map<String, Object> parameters, SplitPageInfo splitPageInfo) throws DataAccessException {
//        return this.dao.selectSplitOnlyData(po, where, parameters, splitPageInfo);
//    }
//
//    @Override
//    public List<Map<String, Object>> selectSplitOnlyData(String sql, Object[] parameters, SplitPageInfo splitPageInfo) throws DataAccessException {
//        return this.dao.selectSplitOnlyData(sql, parameters, splitPageInfo);
//    }
    /**
     * @see com.walker.jdbc.service.BaseService#saveOrder(String, String[])
     */
    @Override
    public void saveOrder(String tableName, String[] ids) {
        if (ids == null || ids.length < 1) {
            return;
        }
        String sql = "update " + tableName + " set sxh = :sxh where id = :id";
        List<Map<String, Object>> params = new ArrayList<>(ids.length);
        for (int i = 0; i < ids.length; i++) {
            Map<String, Object> m = new HashMap<>();
            m.put("sxh", i + 1);
            m.put("id", ids[i]);
            params.add(m);
        }
        this.execBatchUpdate(sql, params);
    }
    @Override
    public <T> void execute(String sql, Object[] parameters, RowMapper<T> rowMapper, RowExecution<T> rowExecution) {
        this.dao.execute(sql, parameters, rowMapper, rowExecution);
    }

    @Override
    public <T extends BasePo<T>> void execute(String sql, Object[] parameters, T po, RowExecution<T> rowExecution) {
        this.dao.execute(sql, parameters, po, rowExecution);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, T po) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, po);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(String sql, Object[] parameters, T po) throws DataAccessException {
        return this.dao.selectSplit(sql,parameters,po);
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Object[] parameters, RowMapper<T> rowMapper) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, rowMapper);
    }

    @Override
    public MapPager selectSplit(String sql, Object[] parameters) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        return this.dao.selectSplit(po, where, parameters);
    }

//    /**
//     * 租户模式下，获取租户ID
//     * @return
//     */
//    public String getTenant() {
//        return TenantContextHolder.getTenant();
//    }
}
