package com.walker.jdbc.util;

import com.walker.infrastructure.ApplicationRuntimeException;

/**
 * sql操作工具类
 *
 * @author ruoyi
 */
public class SqlUtils {
    /**
     * 定义常用的 sql关键字
     */
    public static final String SQL_REGEX = "select |insert |delete |update |drop |count |exec |chr |mid |master |truncate |char |and |declare ";

    /**
     * 仅支持字母、数字、下划线、空格、逗号、小数点（支持多个字段排序）
     */
    public static final String SQL_PATTERN = "[a-zA-Z0-9_\\ \\,\\.]+";

    /**
     * 把原始sql变成oracle分页语句。
     * @param sql
     * @return
     * @date 2023-03-03
     */
    public static final String getOraclePageSql(String sql){
        return new StringBuilder(PAGE_PREFIX_ORACLE).append(sql).append(PAGE_SUFFIX_ORACLE).toString();
    }

    public static final String PAGE_PREFIX_ORACLE = "select * from (select row_.*, rownum rownum_ from (";
    public static final String PAGE_SUFFIX_ORACLE = ") row_ where rownum <= ?) where rownum_ >= ?";

    /**
     * 检查字符，防止注入绕过
     */
    public static String escapeOrderBySql(String value) {
        if (StringUtils.isNotEmpty(value) && !isValidOrderBySql(value)) {
            throw new ApplicationRuntimeException("参数不符合规范，不能进行查询");
        }
        return value;
    }

    /**
     * 验证 order by 语法是否符合规范
     */
    public static boolean isValidOrderBySql(String value)
    {
        return value.matches(SQL_PATTERN);
    }

    /**
     * SQL关键字检查
     */
    public static void filterKeyword(String value) {
        if (StringUtils.isEmpty(value)) {
            return;
        }
        String[] sqlKeywords = StringUtils.split(SQL_REGEX, "\\|");
        for (String sqlKeyword : sqlKeywords) {
            if (org.apache.commons.lang3.StringUtils.indexOfIgnoreCase(value, sqlKeyword) > -1) {
                throw new ApplicationRuntimeException("参数存在SQL注入风险");
            }
        }
    }
}
